/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.typings;

import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.typings.TypeDefinitionGenerator;
import apex.jorje.lsp.impl.typings.TypeDefinitionModule;
import apex.jorje.lsp.impl.typings.TypeDefinitionWriter;
import apex.jorje.lsp.impl.utils.SfdxProjects;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Typings {
    private static final PathMatcher TYPE_DEFINITION_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**.d.ts");
    private static final Logger logger = LoggerFactory.getLogger(Typings.class);
    private final TypeDefinitionWriter typeDefinitionWriter;
    private final ApexCompilerService compilerService;
    private final ApexDocumentService documentService;
    private final SfdxProjects sfdxProjectsUtil;

    @Inject
    public Typings(TypeDefinitionWriter typeDefinitionWriter, ApexCompilerService compilerService, ApexDocumentService documentService, SfdxProjects sfdxProjectsUtil) {
        this.typeDefinitionWriter = typeDefinitionWriter;
        this.compilerService = compilerService;
        this.documentService = documentService;
        this.sfdxProjectsUtil = sfdxProjectsUtil;
    }

    public void removeTypeDefinitionFiles() {
        try {
            Path apexTypingsFolder = this.typeDefinitionWriter.getApexTypingsFolder();
            if (Files.exists(apexTypingsFolder, new LinkOption[0])) {
                Files.walk(apexTypingsFolder, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).filter(TYPE_DEFINITION_MATCHER::matches).map(Path::toFile).forEach(File::delete);
            }
        }
        catch (IOException ioe) {
            logger.error("Failed to delete the d.ts files at {}", (Object)this.typeDefinitionWriter.getApexTypingsFolder(), (Object)ioe);
        }
    }

    public void generateTypeDefinitions(Map<String, Set<URI>> apexUris) {
        apexUris.forEach((s, uris) -> uris.forEach(uri -> {
            Optional<Document> document = this.documentService.retrieve((URI)uri);
            document.ifPresent(doc -> {
                TypeDefinitionGenerator generator = new TypeDefinitionGenerator(this.compilerService, this.sfdxProjectsUtil, (Document)doc);
                Optional<TypeDefinitionModule> module = generator.buildModulesIfApplicable();
                module.ifPresent(this.typeDefinitionWriter::writeModule);
            });
        }));
    }
}

