/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data.errors;

import apex.jorje.data.Location;

public abstract class SyntaxError {
    private SyntaxError() {
    }

    public static final SyntaxError _MismatchedSyntax(Location loc, String actual, String expected) {
        return new MismatchedSyntax(loc, actual, expected);
    }

    public static final SyntaxError _MissingSyntax(Location loc, String actual, String expected) {
        return new MissingSyntax(loc, actual, expected);
    }

    public static final SyntaxError _UnmatchedSyntax(Location loc, String actual, String expected) {
        return new UnmatchedSyntax(loc, actual, expected);
    }

    public static final SyntaxError _UnexpectedSyntaxError(Location loc, String message) {
        return new UnexpectedSyntaxError(loc, message);
    }

    public static final SyntaxError _UnexpectedToken(Location loc, String token) {
        return new UnexpectedToken(loc, token);
    }

    public static final SyntaxError _UnexpectedEof(Location loc) {
        return new UnexpectedEof(loc);
    }

    public static final SyntaxError _IllegalStringLiteral(Location loc, String message) {
        return new IllegalStringLiteral(loc, message);
    }

    public static final SyntaxError _IllegalIntegerLiteral(Location loc) {
        return new IllegalIntegerLiteral(loc);
    }

    public static final SyntaxError _IllegalLongLiteral(Location loc) {
        return new IllegalLongLiteral(loc);
    }

    public static final SyntaxError _IllegalDoubleLiteral(Location loc) {
        return new IllegalDoubleLiteral(loc);
    }

    public static final SyntaxError _IllegalDecimalLiteral(Location loc) {
        return new IllegalDecimalLiteral(loc);
    }

    public abstract <ResultType> ResultType match(MatchBlock<ResultType> var1);

    public abstract void _switch(SwitchBlock var1);

    public static final class IllegalDecimalLiteral
    extends SyntaxError {
        public Location loc;

        public IllegalDecimalLiteral(Location loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IllegalDecimalLiteral other = (IllegalDecimalLiteral)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "IllegalDecimalLiteral(loc = " + this.loc + ")";
        }
    }

    public static final class IllegalDoubleLiteral
    extends SyntaxError {
        public Location loc;

        public IllegalDoubleLiteral(Location loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IllegalDoubleLiteral other = (IllegalDoubleLiteral)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "IllegalDoubleLiteral(loc = " + this.loc + ")";
        }
    }

    public static final class IllegalLongLiteral
    extends SyntaxError {
        public Location loc;

        public IllegalLongLiteral(Location loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IllegalLongLiteral other = (IllegalLongLiteral)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "IllegalLongLiteral(loc = " + this.loc + ")";
        }
    }

    public static final class IllegalIntegerLiteral
    extends SyntaxError {
        public Location loc;

        public IllegalIntegerLiteral(Location loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IllegalIntegerLiteral other = (IllegalIntegerLiteral)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "IllegalIntegerLiteral(loc = " + this.loc + ")";
        }
    }

    public static final class IllegalStringLiteral
    extends SyntaxError {
        public Location loc;
        public String message;

        public IllegalStringLiteral(Location loc, String message) {
            this.loc = loc;
            this.message = message;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IllegalStringLiteral other = (IllegalStringLiteral)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.message == null ? other.message != null : !this.message.equals(other.message));
        }

        public String toString() {
            return "IllegalStringLiteral(loc = " + this.loc + ", message = " + this.message + ")";
        }
    }

    public static final class UnexpectedEof
    extends SyntaxError {
        public Location loc;

        public UnexpectedEof(Location loc) {
            this.loc = loc;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnexpectedEof other = (UnexpectedEof)obj;
            return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
        }

        public String toString() {
            return "UnexpectedEof(loc = " + this.loc + ")";
        }
    }

    public static final class UnexpectedToken
    extends SyntaxError {
        public Location loc;
        public String token;

        public UnexpectedToken(Location loc, String token) {
            this.loc = loc;
            this.token = token;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.token == null ? 0 : this.token.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnexpectedToken other = (UnexpectedToken)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.token == null ? other.token != null : !this.token.equals(other.token));
        }

        public String toString() {
            return "UnexpectedToken(loc = " + this.loc + ", token = " + this.token + ")";
        }
    }

    public static final class UnexpectedSyntaxError
    extends SyntaxError {
        public Location loc;
        public String message;

        public UnexpectedSyntaxError(Location loc, String message) {
            this.loc = loc;
            this.message = message;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnexpectedSyntaxError other = (UnexpectedSyntaxError)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            return !(this.message == null ? other.message != null : !this.message.equals(other.message));
        }

        public String toString() {
            return "UnexpectedSyntaxError(loc = " + this.loc + ", message = " + this.message + ")";
        }
    }

    public static final class UnmatchedSyntax
    extends SyntaxError {
        public Location loc;
        public String actual;
        public String expected;

        public UnmatchedSyntax(Location loc, String actual, String expected) {
            this.loc = loc;
            this.actual = actual;
            this.expected = expected;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.actual == null ? 0 : this.actual.hashCode());
            result = 31 * result + (this.expected == null ? 0 : this.expected.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnmatchedSyntax other = (UnmatchedSyntax)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            if (this.actual == null ? other.actual != null : !this.actual.equals(other.actual)) {
                return false;
            }
            return !(this.expected == null ? other.expected != null : !this.expected.equals(other.expected));
        }

        public String toString() {
            return "UnmatchedSyntax(loc = " + this.loc + ", actual = " + this.actual + ", expected = " + this.expected + ")";
        }
    }

    public static final class MissingSyntax
    extends SyntaxError {
        public Location loc;
        public String actual;
        public String expected;

        public MissingSyntax(Location loc, String actual, String expected) {
            this.loc = loc;
            this.actual = actual;
            this.expected = expected;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.actual == null ? 0 : this.actual.hashCode());
            result = 31 * result + (this.expected == null ? 0 : this.expected.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MissingSyntax other = (MissingSyntax)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            if (this.actual == null ? other.actual != null : !this.actual.equals(other.actual)) {
                return false;
            }
            return !(this.expected == null ? other.expected != null : !this.expected.equals(other.expected));
        }

        public String toString() {
            return "MissingSyntax(loc = " + this.loc + ", actual = " + this.actual + ", expected = " + this.expected + ")";
        }
    }

    public static final class MismatchedSyntax
    extends SyntaxError {
        public Location loc;
        public String actual;
        public String expected;

        public MismatchedSyntax(Location loc, String actual, String expected) {
            this.loc = loc;
            this.actual = actual;
            this.expected = expected;
        }

        @Override
        public <ResultType> ResultType match(MatchBlock<ResultType> matchBlock) {
            return matchBlock._case(this);
        }

        @Override
        public void _switch(SwitchBlock switchBlock) {
            switchBlock._case(this);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
            result = 31 * result + (this.actual == null ? 0 : this.actual.hashCode());
            result = 31 * result + (this.expected == null ? 0 : this.expected.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MismatchedSyntax other = (MismatchedSyntax)obj;
            if (this.loc == null ? other.loc != null : !this.loc.equals(other.loc)) {
                return false;
            }
            if (this.actual == null ? other.actual != null : !this.actual.equals(other.actual)) {
                return false;
            }
            return !(this.expected == null ? other.expected != null : !this.expected.equals(other.expected));
        }

        public String toString() {
            return "MismatchedSyntax(loc = " + this.loc + ", actual = " + this.actual + ", expected = " + this.expected + ")";
        }
    }

    public static abstract class SwitchBlockWithDefault
    implements SwitchBlock {
        @Override
        public void _case(MismatchedSyntax x) {
            this._default(x);
        }

        @Override
        public void _case(MissingSyntax x) {
            this._default(x);
        }

        @Override
        public void _case(UnmatchedSyntax x) {
            this._default(x);
        }

        @Override
        public void _case(UnexpectedSyntaxError x) {
            this._default(x);
        }

        @Override
        public void _case(UnexpectedToken x) {
            this._default(x);
        }

        @Override
        public void _case(UnexpectedEof x) {
            this._default(x);
        }

        @Override
        public void _case(IllegalStringLiteral x) {
            this._default(x);
        }

        @Override
        public void _case(IllegalIntegerLiteral x) {
            this._default(x);
        }

        @Override
        public void _case(IllegalLongLiteral x) {
            this._default(x);
        }

        @Override
        public void _case(IllegalDoubleLiteral x) {
            this._default(x);
        }

        @Override
        public void _case(IllegalDecimalLiteral x) {
            this._default(x);
        }

        protected abstract void _default(SyntaxError var1);
    }

    public static interface SwitchBlock {
        public void _case(MismatchedSyntax var1);

        public void _case(MissingSyntax var1);

        public void _case(UnmatchedSyntax var1);

        public void _case(UnexpectedSyntaxError var1);

        public void _case(UnexpectedToken var1);

        public void _case(UnexpectedEof var1);

        public void _case(IllegalStringLiteral var1);

        public void _case(IllegalIntegerLiteral var1);

        public void _case(IllegalLongLiteral var1);

        public void _case(IllegalDoubleLiteral var1);

        public void _case(IllegalDecimalLiteral var1);
    }

    public static abstract class MatchBlockWithDefault<ResultType>
    implements MatchBlock<ResultType> {
        @Override
        public ResultType _case(MismatchedSyntax x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(MissingSyntax x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(UnmatchedSyntax x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(UnexpectedSyntaxError x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(UnexpectedToken x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(UnexpectedEof x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(IllegalStringLiteral x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(IllegalIntegerLiteral x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(IllegalLongLiteral x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(IllegalDoubleLiteral x) {
            return this._default(x);
        }

        @Override
        public ResultType _case(IllegalDecimalLiteral x) {
            return this._default(x);
        }

        protected abstract ResultType _default(SyntaxError var1);
    }

    public static interface MatchBlock<ResultType> {
        public ResultType _case(MismatchedSyntax var1);

        public ResultType _case(MissingSyntax var1);

        public ResultType _case(UnmatchedSyntax var1);

        public ResultType _case(UnexpectedSyntaxError var1);

        public ResultType _case(UnexpectedToken var1);

        public ResultType _case(UnexpectedEof var1);

        public ResultType _case(IllegalStringLiteral var1);

        public ResultType _case(IllegalIntegerLiteral var1);

        public ResultType _case(IllegalLongLiteral var1);

        public ResultType _case(IllegalDoubleLiteral var1);

        public ResultType _case(IllegalDecimalLiteral var1);
    }
}

