/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.data.ast;

public enum BinaryOp {
    ADDITION("+"),
    SUBTRACTION("-"),
    MULTIPLICATION("*"),
    DIVISION("/"),
    LEFT_SHIFT("<<"),
    RIGHT_SHIFT(">>"),
    UNSIGNED_RIGHT_SHIFT(">>>"),
    XOR("^"),
    AND("&"),
    OR("|");

    private final String code;

    private BinaryOp(String code) {
        this.code = code;
    }

    public boolean isArithmetic() {
        switch (this) {
            case ADDITION: 
            case SUBTRACTION: 
            case MULTIPLICATION: 
            case DIVISION: {
                return true;
            }
        }
        return false;
    }

    public boolean isShift() {
        switch (this) {
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: {
                return true;
            }
        }
        return false;
    }

    public boolean isBitwise() {
        switch (this) {
            case XOR: 
            case AND: 
            case OR: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.code;
    }
}

