/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.util.CollectionUtil;
import org.apache.commons.lang3.StringUtils;

@Deprecated
@InternalApi
public final class StringUtil {
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final Pattern XML_10_INVALID_CHARS = Pattern.compile("\\x00|\\x01|\\x02|\\x03|\\x04|\\x05|\\x06|\\x07|\\x08|\\x0b|\\x0c|\\x0e|\\x0f|\\x10|\\x11|\\x12|\\x13|\\x14|\\x15|\\x16|\\x17|\\x18|\\x19|\\x1a|\\x1b|\\x1c|\\x1d|\\x1e|\\x1f");

    private StringUtil() {
    }

    public static int lineNumberAt(CharSequence charSeq, int offsetInclusive) {
        int len = charSeq.length();
        if (offsetInclusive > len || offsetInclusive < 0) {
            return -1;
        }
        int l = 1;
        for (int curOffset = 0; curOffset < offsetInclusive; ++curOffset) {
            if (curOffset >= len) {
                return -1;
            }
            char c = charSeq.charAt(curOffset);
            if (c == '\n') {
                ++l;
                continue;
            }
            if (c != '\r') continue;
            if (curOffset + 1 < len && charSeq.charAt(curOffset + 1) == '\n') {
                if (curOffset == offsetInclusive - 1) {
                    return l;
                }
                ++curOffset;
            }
            ++l;
        }
        return l;
    }

    public static int columnNumberAt(CharSequence charSeq, int offsetInclusive) {
        if (offsetInclusive == charSeq.length()) {
            return charSeq.length() == 0 ? 1 : 1 + StringUtil.columnNumberAt(charSeq, offsetInclusive - 1);
        }
        if (offsetInclusive > charSeq.length() || offsetInclusive < 0) {
            return -1;
        }
        int col = 0;
        char next = '\u0000';
        for (int i = offsetInclusive; i >= 0; --i) {
            char c = charSeq.charAt(i);
            if (offsetInclusive != i && (c == '\n' || c == '\r' && next != '\n')) {
                return col;
            }
            ++col;
            next = c;
        }
        return col;
    }

    public static String percentageString(double val, int numDecimals) {
        if (val < 0.0 || val > 1.0) {
            throw new IllegalArgumentException("Expected a number between 0 and 1");
        }
        return String.format(Locale.ROOT, "%." + numDecimals + "f%%", 100.0 * val);
    }

    @Deprecated
    public static boolean startsWithAny(String text, String ... prefixes) {
        for (String prefix : prefixes) {
            if (!text.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnyOf(String text, String ... tests) {
        for (String test : tests) {
            if (!text.equals(test)) continue;
            return true;
        }
        return false;
    }

    public static String withoutPrefixes(String text, String ... prefixes) {
        for (String prefix : prefixes) {
            if (!text.startsWith(prefix)) continue;
            return text.substring(prefix.length());
        }
        return text;
    }

    @Deprecated
    public static boolean isNotEmpty(String value) {
        return !StringUtil.isEmpty(value);
    }

    @Deprecated
    public static boolean isEmpty(String value) {
        return StringUtils.isBlank((CharSequence)value);
    }

    @Deprecated
    public static boolean isMissing(String value) {
        return StringUtils.isEmpty((CharSequence)value);
    }

    @Deprecated
    public static boolean areSemanticEquals(String a, String b) {
        if (a == null) {
            return StringUtil.isEmpty(b);
        }
        if (b == null) {
            return StringUtil.isEmpty(a);
        }
        return a.equals(b);
    }

    @Deprecated
    public static String replaceString(String original, String oldString, String newString) {
        int index = original.indexOf(oldString);
        if (index < 0) {
            return original;
        }
        String replace = newString == null ? "" : newString;
        StringBuilder buf = new StringBuilder(Math.max(16, original.length() + replace.length()));
        int last = 0;
        while (index != -1) {
            buf.append(original.substring(last, index));
            buf.append(replace);
            last = index + oldString.length();
            index = original.indexOf(oldString, last);
        }
        buf.append(original.substring(last));
        return buf.toString();
    }

    @Deprecated
    public static void appendXmlEscaped(StringBuilder buf, String src, boolean supportUTF8) {
        int i = 0;
        while (i < src.length()) {
            int c;
            if ((c = src.charAt(i++)) > 126) {
                if (!supportUTF8) {
                    int codepoint = c;
                    if (Character.isHighSurrogate((char)c)) {
                        char low = src.charAt(i++);
                        codepoint = Character.toCodePoint((char)c, low);
                    }
                    buf.append("&#x").append(Integer.toHexString(codepoint)).append(';');
                    continue;
                }
                buf.append((char)c);
                continue;
            }
            if (c == 38) {
                buf.append("&amp;");
                continue;
            }
            if (c == 34) {
                buf.append("&quot;");
                continue;
            }
            if (c == 60) {
                buf.append("&lt;");
                continue;
            }
            if (c == 62) {
                buf.append("&gt;");
                continue;
            }
            buf.append((char)c);
        }
    }

    public static String removedInvalidXml10Characters(String text) {
        Matcher matcher = XML_10_INVALID_CHARS.matcher(text);
        return matcher.replaceAll("");
    }

    public static String escapeWhitespace(Object o) {
        if (o == null) {
            return null;
        }
        String s = String.valueOf(o);
        s = s.replace("\n", "\\n");
        s = s.replace("\r", "\\r");
        s = s.replace("\t", "\\t");
        return s;
    }

    @Deprecated
    public static String replaceString(String original, char oldChar, String newString) {
        int index = original.indexOf(oldChar);
        if (index < 0) {
            return original;
        }
        String replace = newString == null ? "" : newString;
        StringBuilder buf = new StringBuilder(Math.max(16, original.length() + replace.length()));
        int last = 0;
        while (index != -1) {
            buf.append(original.substring(last, index));
            buf.append(replace);
            last = index + 1;
            index = original.indexOf(oldChar, last);
        }
        buf.append(original.substring(last));
        return buf.toString();
    }

    @Deprecated
    public static String[] substringsOf(String source, char delimiter) {
        if (source == null || source.length() == 0) {
            return EMPTY_STRINGS;
        }
        int delimiterCount = 0;
        int length = source.length();
        char[] chars = source.toCharArray();
        for (int i = 0; i < length; ++i) {
            if (chars[i] != delimiter) continue;
            ++delimiterCount;
        }
        if (delimiterCount == 0) {
            return new String[]{source};
        }
        String[] results = new String[delimiterCount + 1];
        int i = 0;
        int offset = 0;
        while (offset <= length) {
            int pos = source.indexOf(delimiter, offset);
            if (pos < 0) {
                pos = length;
            }
            results[i++] = pos == offset ? "" : source.substring(offset, pos);
            offset = pos + 1;
        }
        return results;
    }

    @Deprecated
    public static String[] substringsOf(String str, String separator) {
        if (str == null || str.length() == 0) {
            return EMPTY_STRINGS;
        }
        int index = str.indexOf(separator);
        if (index == -1) {
            return new String[]{str};
        }
        ArrayList<String> list = new ArrayList<String>();
        int currPos = 0;
        int len = separator.length();
        while (index != -1) {
            list.add(str.substring(currPos, index));
            currPos = index + len;
            index = str.indexOf(separator, currPos);
        }
        list.add(str.substring(currPos));
        return list.toArray(new String[0]);
    }

    @Deprecated
    public static void asStringOn(StringBuffer sb, Iterator<?> iter, String separator) {
        if (!iter.hasNext()) {
            return;
        }
        sb.append(iter.next());
        while (iter.hasNext()) {
            sb.append(separator);
            sb.append(iter.next());
        }
    }

    @Deprecated
    public static void asStringOn(StringBuilder sb, Object[] items, String separator) {
        if (items == null || items.length == 0) {
            return;
        }
        sb.append(items[0]);
        for (int i = 1; i < items.length; ++i) {
            sb.append(separator);
            sb.append(items[i]);
        }
    }

    public static int maxCommonLeadingWhitespaceForAll(String[] strings) {
        int shortest = StringUtil.lengthOfShortestIn(strings);
        if (shortest == 0) {
            return 0;
        }
        char[] matches = new char[shortest];
        for (int m = 0; m < matches.length; ++m) {
            matches[m] = strings[0].charAt(m);
            if (!Character.isWhitespace(matches[m])) {
                return m;
            }
            for (int i = 0; i < strings.length; ++i) {
                String str = strings[i];
                if (str.charAt(m) == matches[m]) continue;
                return m;
            }
        }
        return shortest;
    }

    public static int lengthOfShortestIn(String[] strings) {
        if (CollectionUtil.isEmpty(strings)) {
            return 0;
        }
        int minLength = Integer.MAX_VALUE;
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i] == null) {
                return 0;
            }
            minLength = Math.min(minLength, strings[i].length());
        }
        return minLength;
    }

    public static String[] trimStartOn(String[] strings, int trimDepth) {
        if (trimDepth == 0) {
            return strings;
        }
        String[] results = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            results[i] = strings[i].substring(trimDepth);
        }
        return results;
    }

    @Deprecated
    public static String lpad(String s, int length) {
        String res = s;
        if (length - s.length() > 0) {
            char[] arr = new char[length - s.length()];
            Arrays.fill(arr, ' ');
            res = new StringBuilder(length).append(arr).append(s).toString();
        }
        return res;
    }

    public static boolean isSame(String s1, String s2, boolean trim, boolean ignoreCase, boolean standardizeWhitespace) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (trim) {
            s1 = s1.trim();
            s2 = s2.trim();
        }
        if (standardizeWhitespace) {
            s1 = s1.replaceAll("\\s+", " ");
            s2 = s2.replaceAll("\\s+", " ");
        }
        return ignoreCase ? s1.equalsIgnoreCase(s2) : s1.equals(s2);
    }

    public static String asString(Object[] items, String separator) {
        if (items == null || items.length == 0) {
            return "";
        }
        if (items.length == 1) {
            return items[0].toString();
        }
        StringBuilder sb = new StringBuilder(items[0].toString());
        for (int i = 1; i < items.length; ++i) {
            sb.append(separator).append(items[i]);
        }
        return sb.toString();
    }

    public static String removeSurrounding(String string, char delimiter) {
        if (string.length() >= 2 && string.charAt(0) == delimiter && string.charAt(string.length() - 1) == delimiter) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String removeDoubleQuotes(String string) {
        return StringUtil.removeSurrounding(string, '\"');
    }

    public static String[] getEmptyStrings() {
        return EMPTY_STRINGS;
    }

    public static String toCamelCase(String name) {
        return StringUtil.toCamelCase(name, false);
    }

    public static String toCamelCase(String name, boolean forceLowerCase) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (String word : name.trim().split("\\s++")) {
            String pretreated;
            String string = pretreated = forceLowerCase ? word.toLowerCase(Locale.ROOT) : word;
            if (isFirst) {
                sb.append(pretreated);
                isFirst = false;
                continue;
            }
            sb.append(StringUtils.capitalize((String)pretreated));
        }
        return sb.toString();
    }

    public static String escapeJava(String str) {
        StringBuilder retval = new StringBuilder();
        block11: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block11;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block11;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block11;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block11;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block11;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block11;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block11;
                }
                default: {
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u").append(s.substring(s.length() - 4));
                        continue block11;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }
}

