/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMarkerAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTMemberValuePair;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTNormalAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTReferenceType;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJUnitRule;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.symboltable.Scope;

public class JUnitTestsShouldIncludeAssertRule
extends AbstractJUnitRule {
    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethodDeclaration method, Object data) {
        if (this.isJUnitMethod(method, data) && !this.isExpectAnnotated(method.getParent())) {
            Map<String, VariableNameDeclaration> variables = this.getVariables(method);
            Scope classScope = method.getScope().getParent();
            Map<String, List<NameOccurrence>> expectables = this.getRuleAnnotatedExpectedExceptions(classScope);
            if (!this.containsExpectOrAssert((Node)method.getBody(), expectables, variables)) {
                this.addViolation(data, method);
            }
        }
        return data;
    }

    private boolean containsExpectOrAssert(Node n, Map<String, List<NameOccurrence>> expectables, Map<String, VariableNameDeclaration> variables) {
        if (n instanceof ASTStatementExpression) {
            if (this.isExpectStatement((ASTStatementExpression)n, expectables) || this.isAssertOrFailStatement((ASTStatementExpression)n) || this.isHamcrestAssert((ASTStatementExpression)n) || this.isVerifyStatement((ASTStatementExpression)n) || this.isSoftAssertionStatement((ASTStatementExpression)n, variables)) {
                return true;
            }
        } else {
            for (int i = 0; i < n.getNumChildren(); ++i) {
                Node c = n.getChild(i);
                if (!this.containsExpectOrAssert(c, expectables, variables)) continue;
                return true;
            }
        }
        return false;
    }

    private Map<String, VariableNameDeclaration> getVariables(ASTMethodDeclaration method) {
        HashMap<String, VariableNameDeclaration> variables = new HashMap<String, VariableNameDeclaration>();
        for (VariableNameDeclaration vnd : method.getScope().getDeclarations(VariableNameDeclaration.class).keySet()) {
            variables.put(vnd.getName(), vnd);
        }
        return variables;
    }

    private Map<String, List<NameOccurrence>> getRuleAnnotatedExpectedExceptions(Scope classScope) {
        HashMap<String, List<NameOccurrence>> result = new HashMap<String, List<NameOccurrence>>();
        Map decls = classScope.getDeclarations();
        for (Map.Entry entry : decls.entrySet()) {
            Node type;
            String annot;
            Node parent = ((NameDeclaration)entry.getKey()).getNode().getParent().getParent().getParent();
            if (!parent.hasDescendantOfType(ASTMarkerAnnotation.class) || parent.getFirstChildOfType(ASTFieldDeclaration.class) == null || !"Rule".equals(annot = ((JavaNode)((ASTMarkerAnnotation)parent.getFirstDescendantOfType(ASTMarkerAnnotation.class)).getChild(0)).getImage()) && !"org.junit.Rule".equals(annot) || !"ExpectedException".equals((type = (Node)parent.getFirstDescendantOfType(ASTReferenceType.class)).getChild(0).getImage())) continue;
            result.put(((NameDeclaration)entry.getKey()).getName(), (List<NameOccurrence>)entry.getValue());
        }
        return result;
    }

    private boolean isExpectAnnotated(Node methodParent) {
        List annotations = methodParent.findDescendantsOfType(ASTNormalAnnotation.class);
        for (ASTNormalAnnotation annotation : annotations) {
            ASTName name = (ASTName)annotation.getFirstChildOfType(ASTName.class);
            if (!TypeTestUtil.isA("org.junit.Test", (TypeNode)name)) continue;
            List memberValues = annotation.findDescendantsOfType(ASTMemberValuePair.class);
            for (ASTMemberValuePair pair : memberValues) {
                if (!"expected".equals(pair.getImage())) continue;
                return true;
            }
        }
        return false;
    }

    private String getMethodCallNameOrNull(ASTStatementExpression expression) {
        Node name;
        ASTPrimaryExpression pe;
        if (expression != null && (pe = (ASTPrimaryExpression)expression.getFirstChildOfType(ASTPrimaryExpression.class)) != null && (name = (Node)pe.getFirstDescendantOfType(ASTName.class)) != null) {
            return name.getImage();
        }
        return null;
    }

    private boolean isHamcrestAssert(ASTStatementExpression expression) {
        String img = this.getMethodCallNameOrNull(expression);
        return "assertThat".equals(img) || "MatcherAssert.assertThat".equals(img);
    }

    private boolean isAssertOrFailStatement(ASTStatementExpression expression) {
        String img = this.getMethodCallNameOrNull(expression);
        return img != null && (img.startsWith("assert") || img.startsWith("fail") || img.startsWith("Assert.assert") || img.startsWith("Assert.fail") || img.startsWith("Assertions.assert") || img.startsWith("Assertions.fail"));
    }

    private boolean isVerifyStatement(ASTStatementExpression expression) {
        String img = this.getMethodCallNameOrNull(expression);
        return img != null && (img.startsWith("verify") || img.startsWith("Mockito.verify"));
    }

    private boolean isExpectStatement(ASTStatementExpression expression, Map<String, List<NameOccurrence>> expectables) {
        ASTPrimaryExpression pe = (ASTPrimaryExpression)expression.getFirstChildOfType(ASTPrimaryExpression.class);
        if (pe != null) {
            List primarySuffixes;
            ASTPrimaryPrefix primaryPrefix = (ASTPrimaryPrefix)pe.getFirstChildOfType(ASTPrimaryPrefix.class);
            Node name = (Node)pe.getFirstDescendantOfType(ASTName.class);
            if (!primaryPrefix.usesThisModifier() && name != null) {
                String[] parts = name.getImage().split("\\.");
                if (parts.length >= 2) {
                    String varname = parts[0];
                    String methodName = parts[1];
                    if (expectables.containsKey(varname) && "expect".equals(methodName)) {
                        return true;
                    }
                }
            } else if (primaryPrefix.usesThisModifier() && (primarySuffixes = pe.findChildrenOfType(ASTPrimarySuffix.class)).size() >= 2) {
                String varname = ((ASTPrimarySuffix)primarySuffixes.get(0)).getImage();
                String methodName = ((ASTPrimarySuffix)primarySuffixes.get(1)).getImage();
                if (expectables.containsKey(varname) && "expect".equals(methodName)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isSoftAssertionStatement(ASTStatementExpression expression, Map<String, VariableNameDeclaration> variables) {
        Node name;
        ASTPrimaryExpression pe;
        if (expression != null && (pe = (ASTPrimaryExpression)expression.getFirstChildOfType(ASTPrimaryExpression.class)) != null && (name = (Node)pe.getFirstDescendantOfType(ASTName.class)) != null) {
            String img = name.getImage();
            if (!img.contains(".")) {
                return false;
            }
            String[] tokens = img.split("\\.");
            String methodName = tokens[1];
            boolean methodIsAssertAll = "assertAll".equals(methodName);
            String varName = tokens[0];
            boolean variableTypeIsSoftAssertion = variables.containsKey(varName) && TypeTestUtil.isA("org.assertj.core.api.AbstractSoftAssertions", (TypeNode)variables.get(varName).getDeclaratorId());
            return methodIsAssertAll && variableTypeIsSoftAssertion;
        }
        return false;
    }
}

