/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.lang.java.ast.ASTCatchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;

public class AvoidReassigningCatchVariablesRule
extends AbstractJavaRule {
    public AvoidReassigningCatchVariablesRule() {
        this.addRuleChainVisit(ASTCatchStatement.class);
    }

    @Override
    public Object visit(ASTCatchStatement catchStatement, Object data) {
        ASTVariableDeclaratorId caughtExceptionId = catchStatement.getExceptionId();
        String caughtExceptionVar = caughtExceptionId.getName();
        for (NameOccurrence usage : caughtExceptionId.getUsages()) {
            String assignedVar;
            JavaNode operation = this.getOperationOfUsage(usage);
            if (!this.isAssignment(operation) || !caughtExceptionVar.equals(assignedVar = this.getAssignedVariableName(operation))) continue;
            this.addViolation(data, (Node)operation, caughtExceptionVar);
        }
        return data;
    }

    private JavaNode getOperationOfUsage(NameOccurrence usage) {
        return (JavaNode)((ASTPrimaryExpression)usage.getLocation().getFirstParentOfType(ASTPrimaryExpression.class)).getParent();
    }

    private boolean isAssignment(JavaNode operation) {
        return operation.hasDescendantOfType(ASTAssignmentOperator.class);
    }

    private String getAssignedVariableName(JavaNode operation) {
        return ((ASTName)operation.getFirstDescendantOfType(ASTName.class)).getImage();
    }
}

