@page CHANGES-2-7 Version 2.7
  
## Version 2.7.0 (Dec 23, 2020)

Changes from version 2.6 which are relevant for users:

- Changes leading to differences with previous versions
  - The definition of the omega angle has been modified to adhere to the IUPAC standard (i.e. with the previous amino acid)

- New contributed modules:
  - A new Funnel module by Stefano Raniolo and Vittorio Limongelli 
     - \ref FUNNEL_PS 
     - \ref FUNNEL 
  - A new Infinite Switch Simulated Tempering in Force module by Glen Hocky
     - \ref FISST
  - A new OPES module by Michele Invernizzi
     - \ref OPES_METAD

- New actions:
  - \ref ENVIRONMENTSIMILARITY from Pablo Piaggi
  - \ref PROJECTION_ON_AXIS from
  - \ref FUNCPATHGENERAL from

- Other improvements:
  - \ref MOLINFO action can now be used multiple times. Every action doing a search will use the latest
    appearance. See \issue{134}.
  - Neighbor lists are now OpenMP and MPI parallel so improving the scalability of all actions employing them
  - It is now possible to pass pdb files with all weights set to zero. Instead of reporting an error,
    PLUMED will now assume they are all equal to 1/n, where n is the number of atoms (see \issue{608}).
  - All the examples in the manual are now displayed with contextual help and regularly tested for correctness.
  - A tool to build PLUMED input directly within a python script has been added (see \issue{611}
    and documentation for class `plumed.InputBuilder()`).
  - Python function `plumed.read_as_pandas()` now also accepts an argument `index_col`.
  - Lepton arithmetics can be used also when reading integers (e.g., `METAD PACE=2*5`, see \issue{614}).

- GROMACS:
  - When using `-hrex` flag, the neighbor lists are update automatically at every exchange step.
    This relaxes the requirements on the choice of `-replex` stride (see \issue{579}, thanks to Chang Junhan).

- Changes in the DRR module
  - Support multi-time stepping. Now the STRIDE keyword should work with DRR correctly.
  - Support reflecting boundary conditions, which should be a better solution to the boundary effect of eABF in non-periodic cases. You can use REFLECTINGWALL to enable it.
  - Stop the simulation when the temperature is not passed from the MD engine to PLUMED. In this case, users should set the temperature by the TEMP keyword.

- Changes in the ISDB module
  - There is a new option for OPTSIGMAMEAN, SEM_MAX that allows to automatically determine an optimal value for SIGMA_MAX

- Changes in the VES module
  - Small changes to TD_MULTICANONICAL and TD_MULTITHERMAL_MULTIBARIC. Bug fix concerning the calculation of the logarithm of the target distribution. Added the keyword EPSILON to avoid dealing with regions of zero target probability.

For developers:
- small fix in `Plumed.h` too avoid unique global symbols (see \issue{549})
- Added `cmd("readInputLines")` to allow reading input from a buffer with comments and continuation lines (see \issue{571}).
- fixed error when the install prefix contained unicode characters

## Version 2.7.1 (Apr 16, 2021)

- Includes all fixes up to 2.6.3
- In python interface, fixed usage of python arrays to allow compatibility with PyPy.
- New/updated patches:
  - updated patch for gromacs-2020.5
  - new patch for gromacs-2021
    - this should work with multiple-time stepping (plumed forces are integrated with the smallest time step, plumed can internally implement a multiple-time step if needed). 
    - Modular simulator is still not supported
    - hrex, lambda cv and replica-exchange are not yet tested
 
## Version 2.7.2 (Jul 27, 2021)

- Includes all fixes up to 2.6.4
- Fixed a bug in the `-hrex` implementation for GROMACS 2020 and 2021 (see #691, thanks to Chang Junhan).
- Changes in the OPES module
  - the CALC_WORK option now outputs the accumulated work, as in METAD, instead of the work done in the last bias update

## Version 2.7.3 (Dec 1, 2021)

- Includes all fixes up to 2.6.5
- GROMACS patches now take a note of the used PLUMED version in the GROMACS log (see \issue{737})
- GROMACS 2021 patch renamed to 2021.4 for consistency.

