@page CHANGES-2-5 Version 2.5

## Version 2.5 (beta)

This page contains changes that will end up in 2.5

Changes from version 2.4 which are relevant for users:
- Changes leading to incompatible behavior:
  - \ref RMSD, \ref MULTI-RMSD, \ref PATHMSD, \ref PROPERTYMAP, \ref PCAVARS, \ref PCARMSD, \ref FIT_TO_TEMPLATE,
    \ref DIPOLE, \ref ALPHARMSD, \ref ANTIBETARMSD, and \ref PARABETARMSD now automatically make molecules whole.
    In case you do not want them to do it, use NOPBC flag,
  - There is some subtle change in the installation layout (see below). There should be no visible effect, however it is now compulsory
    to set correctly the `LD_LIBRARY_PATH` variable for the linux executable to work correctly. The procedure has been tested well on OSX and Linux,
    but could give problems on other platform. Please report possible problems on the mailing list.
  - \ref driver now stops correctly when using \ref COMMITTOR. If you want to continue the analysis, use the `NOSTOP` flag in \ref COMMITTOR.

- New actions:
  - \ref COLLECT_FRAMES
  - \ref EUCLIDEAN_DISSIMILARITIES
  - \ref HBPAMM_MATRIX
  - \ref HBPAMM_SH
  - \ref LANDMARK_SELECT_FPS
  - \ref LANDMARK_SELECT_RANDOM
  - \ref LANDMARK_SELECT_STAGED
  - \ref LANDMARK_SELECT_STRIDE
  - \ref OUTPUT_ANALYSIS_DATA_TO_COLVAR
  - \ref OUTPUT_ANALYSIS_DATA_TO_PDB
  - \ref OUTPUT_PCA_PROJECTION
  - \ref PAMM
  - \ref PLUMED
  - \ref PRINT_DISSIMILARITY_MATRIX
  - \ref PROJECT_ALL_ANALYSIS_DATA
  - \ref READ_DISSIMILARITY_MATRIX
  - \ref RESELECT_LANDMARKS
  - \ref REWEIGHT_WHAM
  - \ref SKETCHMAP_CONJGRAD
  - \ref SKETCHMAP_POINTWISE
  - \ref SKETCHMAP_READ
  - \ref SKETCHMAP_SMACOF
  - \ref SKETCH_MAP
  - \ref SMACOF_MDS
  - \ref WHAM_HISTOGRAM
  - \ref WHAM_WEIGHTS

- New command line tools:
  - \ref completion (used to generate command line completion scripts).
  - \ref pdbrenumber (see \issue{371}).

- Changes in the ISDB module
  - \ref CS2BACKBONE is now mpi parallelised in particular with DOSCORE and CAMSHIFT
  - \ref SAXS has an additional implementation based on bessel functions that can be faster for large systems (new keyword BESSEL)
  - \ref METAINFERENCE and all related methods has a new keyword REGRES_ZERO to scale data using a linear scale fit
  - \ref CALIBER new bias to perform Maximum Caliber replica-averaged restrained simulations 

- Changes in the eABF/DRR module (contributed by Haochuan Chen and Haohao Fu):
  - \ref DRR now supports the extended generalized ABF(egABF) method.
  - \ref DRR accepts different GRID options for CVs and extended variables.
  - The MAXFACTOR option is added in \ref DRR to control the factor of biasing force.
  - \ref drr_tool can calculate the divergence of gradients now. (Maybe useful for future pABF)
  - Fix conflicts of output files in multiple replicas.

- Changes in the EDS module:
  - \ref EDS implements Levenberg-Marquardt optimization in addition to previous gradient descent. 
  - \ref EDS no longer automatically increases prefactor for bias parameter updates. This results in more stable optimization for the cases tested.
  - \ref EDS now has a larger default RANGE parameter to go with these other changes.

- Other changes:
  - \ref METAD there is a new FLYING_GAUSSIAN keyword to activate the flying gaussian methods by Spiwok (contributed by Spiwok and Hozzova)
  - \ref EXTERNAL can now SCALE the input grid. This allows for more flexibility without modifying the grid file.
  - \ref ALPHABETA can now combine dihedrals with different coefficients
  - \ref INCLUDE can now be used also before setup actions.
  - \ref CENTER can now be computed using trigonometric functions (PHASES) to simplify its calculation with PBCs.
  - Libmatheval is not used anymore. \ref MATHEVAL (and \ref CUSTOM) are still available
    but employ an internal implementation of the lepton library.
    Functions available in libmatheval and absent in the original lepton library have been added so as to have backward compatbility.
    `atan2(y,x)` function has also been added.
    Notice that MATHEVAL (and CUSTOM) \ref switchingfunction "switching functions"
    using the lepton library have been further optimized with respect to PLUMED 2.4.
    Finally, notice that it is possible to use asmjit to optimize performance (see \ref Lepton).
  - Implemented bash autocompletion, see \ref BashAutocompletion.
  - \ref MOLINFO now allows selecting atoms from chains with a numeric ID (see \issue{320}).
  - Removed the patch for GMX 5.1.4
  - \ref RMSD calculation has been optimized. This should positively affect the performances of CVs where
     many RMSDs are computed on small groups of atoms, such as secondary structure variables.
  - In \ref METAD, when using a bias factor equal to one (no bias) the `rct` component is set to zero rather than to one.
  - New shortcuts are available for selecting atoms: `@allatoms` and `@mdatoms` (see \ref atomSpecs).
  - When using \ref MOLINFO, also the following shortcuts are available for selecting atoms: `@nucleic`, `@protein`, `@water`, `@ions`, `@hydrogens`, `@nonhydrogens`.
  - When using \ref MOLINFO, individual atoms can be chosen also from water molecules (e.g. `@OW-100`).
  - Additional switching function COSINUS contributed by Michael King

Changes from version 2.4 which are relevant for developers:
- Code has been cleanup up replacing a number of pointers with `std::unique_ptr`. All `delete` statements
  in the core parts of the code have been eliminated.
- Exceptions cannot be disabled (`--disable-cxx-exceptions` option has been removed from `./configure`).
- Every exception thrown in PLUMED now also writes its message on PLUMED log.
- The installation layout of shared libraries has been modified. In particular,
  both `libplumed.so` and `plumed` links to `libplumedKernel.so`.
  This reduces considerably the size of the installed package. In addition, it allows
  using two-level namespace on OSX. Notice that this implies that on Linux one should
  always set the `LD_LIBRARY_PATH` flag to have a working executable.
- List of preferred compilers (used when `CXX` or `CC` are not set) has been changed. On OSX, `./configure` will try `clang++/clang` as first choices.
- Added `--enable-static-archive` to `./configure` to build a `libplumed.a` static library.
- Stop setting `DYLD_LIBRARY_PATH` in `sourceme.sh` and in modulefile. Notice that as of PLUMED v2.3.3
  it should not be needed.
- Coverage scan is not anymore contained in developer manual. It can be found in a separate repository
  `github.com/coverage-branch` (see \issue{348}). In addition, coverage for third-party libraries included in PLUMED
  is reported as well.
- It is not possible anymore to use `make install prefix=/path`. Prefix can only be changed during `./configure` (see \issue{332}).
- Exception class has been rewritten to allow more extensive messages. Now also function name is shown.
- On linux, library is linked with `-Bsymbolic`.
- A small number of header files is installed
- When launching `plumed`, flags `--no-mpi` and `--mpi` can appear multiple times. The last appearence is the effective one.
- Internal blas and lapack libraries updated to gromacs 2018.
- Choosing `./configure --prefix=$PWD` does not lead anymore to deletion of all header files.
- Runtime loader in `Plumed.c` now works also when linked without `-rdynamic` (that is, 
  its names are not exported). Notice that all the combinations are expected to
  work, that is: `Plumed.c` from <=2.4 or >=2.5 combined with libplumedKernel
  from <=2.4 or >=2.5. In order to achieve this the following changes are implemented:
  - libplumedKernel does not depend anymore on `Plumed.c`. This allows loading it even
    in cases where names in the loader are not visible. The relevant function needed
    to be compatible with `Plumed.c` <=2.4 are found using `dlsym`.
  - `Plumed.c` does not need anymore libplumedKernel to register itself, but rather
    searches the relevant functions using `dlsym`. In addition, if it is not able to
    load `libplumedKernel` since the latter is <=2.4 and needs `Plumed.c` to be visible,
    it just uses as a fallback `libplumed`, which should load properly.
- A copy of `plumed-runtime` is installed in `prefix/lib/plumed` and can be used for testing.
- Absolute/relative soname/install_name can be configured on linux/OSX. This feature is only
  for testing, the default choice is the typical one used on the respective operating system.
- On OSX, `plumed` and `libplumed.dylib` will find `libplumedKernel.dylib` using `@loader_path`.
