/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.nl.captcha.gimpy;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.security.SecureRandom;
import java.util.Random;
import jj.play.ns.nl.captcha.gimpy.GimpyRenderer;

public class ShearGimpyRenderer
implements GimpyRenderer {
    private final Random _gen = new SecureRandom();
    private final Color _color;

    public ShearGimpyRenderer() {
        this(Color.GRAY);
    }

    public ShearGimpyRenderer(Color color) {
        this._color = color;
    }

    public void gimp(BufferedImage bufferedImage) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.shearX(graphics2D, bufferedImage.getWidth(), bufferedImage.getHeight());
        this.shearY(graphics2D, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.dispose();
    }

    private void shearX(Graphics2D graphics2D, int n, int n2) {
        int n3 = this._gen.nextInt(10) + 5;
        boolean bl = true;
        int n4 = 15;
        int n5 = this._gen.nextInt(5) + 2;
        for (int i = 0; i < n2; ++i) {
            double d = (double)(n3 >> 1) * Math.sin((double)i / (double)n3 + Math.PI * 2 * (double)n5 / (double)n4);
            graphics2D.copyArea(0, i, n, 1, (int)d, 0);
            if (!bl) continue;
            graphics2D.setColor(this._color);
            graphics2D.drawLine((int)d, i, 0, i);
            graphics2D.drawLine((int)d + n, i, n, i);
        }
    }

    private void shearY(Graphics2D graphics2D, int n, int n2) {
        int n3 = this._gen.nextInt(30) + 10;
        boolean bl = true;
        int n4 = 15;
        int n5 = 7;
        for (int i = 0; i < n; ++i) {
            double d = (double)(n3 >> 1) * Math.sin((double)((float)i / (float)n3) + Math.PI * 2 * (double)n5 / (double)n4);
            graphics2D.copyArea(i, 0, 1, n2, 0, (int)d);
            if (!bl) continue;
            graphics2D.setColor(this._color);
            graphics2D.drawLine(i, (int)d, i, 0);
            graphics2D.drawLine(i, (int)d + n2, i, n2);
        }
    }
}

