/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.bytecode.transformation.asm;

import java.util.List;
import org.apache.commons.javaflow.bytecode.StackRecorder;
import org.apache.commons.javaflow.bytecode.transformation.asm.ContinuationMethodAnalyzer;
import org.apache.commons.javaflow.bytecode.transformation.asm.MonitoringFrame;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;

public final class ContinuationMethodAdapter
extends MethodVisitor
implements Opcodes {
    private static final String STACK_RECORDER = Type.getInternalName(StackRecorder.class);
    private static final String POP_METHOD = "pop";
    private static final String PUSH_METHOD = "push";
    private final ContinuationMethodAnalyzer canalyzer;
    private final Analyzer analyzer;
    private Label startLabel = new Label();
    private final List<Label> labels;
    private final List<MethodInsnNode> nodes;
    private final int stackRecorderVar;
    private final boolean isStatic;
    private final String methodDesc;
    private int currentIndex = 0;
    private Frame currentFrame = null;
    private static String[] SUFFIXES = new String[]{"Object", "Int", "Int", "Int", "Int", "Int", "Float", "Long", "Double", "Object", "Object"};

    public ContinuationMethodAdapter(ContinuationMethodAnalyzer a) {
        super(327680, a.mv);
        this.canalyzer = a;
        this.analyzer = a.analyzer;
        this.labels = a.labels;
        this.nodes = a.nodes;
        this.stackRecorderVar = a.stackRecorderVar;
        this.isStatic = (a.access & 8) > 0;
        this.methodDesc = a.desc;
    }

    public void visitCode() {
        this.mv.visitCode();
        int fsize = this.labels.size();
        Label[] restoreLabels = new Label[fsize];
        for (int i = 0; i < restoreLabels.length; ++i) {
            restoreLabels[i] = new Label();
        }
        Label l0 = new Label();
        this.mv.visitMethodInsn(184, STACK_RECORDER, "get", "()L" + STACK_RECORDER + ";", false);
        this.mv.visitInsn(89);
        this.mv.visitVarInsn(58, this.stackRecorderVar);
        this.mv.visitLabel(this.startLabel);
        this.mv.visitJumpInsn(198, l0);
        this.mv.visitVarInsn(25, this.stackRecorderVar);
        this.mv.visitFieldInsn(180, STACK_RECORDER, "isRestoring", "Z");
        this.mv.visitJumpInsn(153, l0);
        this.mv.visitVarInsn(25, this.stackRecorderVar);
        this.mv.visitMethodInsn(182, STACK_RECORDER, "popInt", "()I", false);
        this.mv.visitTableSwitchInsn(0, fsize - 1, l0, restoreLabels);
        for (int i = 0; i < fsize; ++i) {
            Label frameLabel = this.labels.get(i);
            this.mv.visitLabel(restoreLabels[i]);
            MethodInsnNode mnode = this.nodes.get(i);
            Frame frame = this.analyzer.getFrames()[this.canalyzer.getIndex((AbstractInsnNode)mnode)];
            int lsize = frame.getLocals();
            for (int j = lsize - 1; j >= 0; --j) {
                BasicValue value = (BasicValue)frame.getLocal(j);
                if (ContinuationMethodAdapter.isNull(value)) {
                    this.mv.visitInsn(1);
                    this.mv.visitVarInsn(58, j);
                    continue;
                }
                if (value == BasicValue.UNINITIALIZED_VALUE || value == BasicValue.RETURNADDRESS_VALUE) continue;
                this.mv.visitVarInsn(25, this.stackRecorderVar);
                Type type = value.getType();
                if (value.isReference()) {
                    this.mv.visitMethodInsn(182, STACK_RECORDER, "popObject", "()Ljava/lang/Object;", false);
                    Type t = value.getType();
                    String desc = t.getDescriptor();
                    if (desc.charAt(0) == '[') {
                        this.mv.visitTypeInsn(192, desc);
                    } else {
                        this.mv.visitTypeInsn(192, t.getInternalName());
                    }
                    this.mv.visitVarInsn(58, j);
                    continue;
                }
                this.mv.visitMethodInsn(182, STACK_RECORDER, this.getPopMethod(type), "()" + type.getDescriptor(), false);
                this.mv.visitVarInsn(type.getOpcode(54), j);
            }
            if (frame instanceof MonitoringFrame) {
                int[] monitoredLocals;
                for (int monitoredLocal : monitoredLocals = ((MonitoringFrame)frame).getMonitored()) {
                    this.mv.visitVarInsn(25, monitoredLocal);
                    this.mv.visitInsn(194);
                }
            }
            int argSize = Type.getArgumentTypes((String)mnode.desc).length;
            int ownerSize = mnode.getOpcode() == 184 ? 0 : 1;
            int initSize = mnode.name.equals("<init>") ? 2 : 0;
            int ssize = frame.getStackSize();
            for (int j = 0; j < ssize - argSize - ownerSize - initSize; ++j) {
                BasicValue value = (BasicValue)frame.getStack(j);
                if (ContinuationMethodAdapter.isNull(value)) {
                    this.mv.visitInsn(1);
                    continue;
                }
                if (value == BasicValue.UNINITIALIZED_VALUE || value == BasicValue.RETURNADDRESS_VALUE) continue;
                if (value.isReference()) {
                    this.mv.visitVarInsn(25, this.stackRecorderVar);
                    this.mv.visitMethodInsn(182, STACK_RECORDER, "popObject", "()Ljava/lang/Object;", false);
                    this.mv.visitTypeInsn(192, value.getType().getInternalName());
                    continue;
                }
                Type type = value.getType();
                this.mv.visitVarInsn(25, this.stackRecorderVar);
                this.mv.visitMethodInsn(182, STACK_RECORDER, this.getPopMethod(type), "()" + type.getDescriptor(), false);
            }
            if (mnode.getOpcode() != 184) {
                BasicValue value = (BasicValue)frame.getStack(ssize - argSize - 1);
                if (ContinuationMethodAdapter.isNull(value)) {
                    this.mv.visitInsn(1);
                } else {
                    this.mv.visitVarInsn(25, this.stackRecorderVar);
                    this.mv.visitMethodInsn(182, STACK_RECORDER, "popReference", "()Ljava/lang/Object;", false);
                    this.mv.visitTypeInsn(192, value.getType().getInternalName());
                }
            }
            for (Type paramType : Type.getArgumentTypes((String)mnode.desc)) {
                this.pushDefault(paramType);
            }
            this.mv.visitJumpInsn(167, frameLabel);
        }
        this.mv.visitLabel(l0);
    }

    public void visitLabel(Label label) {
        if (this.currentIndex < this.labels.size() && label == this.labels.get(this.currentIndex)) {
            int i = this.canalyzer.getIndex((AbstractInsnNode)this.nodes.get(this.currentIndex));
            this.currentFrame = this.analyzer.getFrames()[i];
        }
        this.mv.visitLabel(label);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
        if (this.currentFrame != null) {
            boolean hasReturn;
            Label fl = new Label();
            this.mv.visitVarInsn(25, this.stackRecorderVar);
            this.mv.visitJumpInsn(198, fl);
            this.mv.visitVarInsn(25, this.stackRecorderVar);
            this.mv.visitFieldInsn(180, STACK_RECORDER, "isCapturing", "Z");
            this.mv.visitJumpInsn(153, fl);
            Type returnType = Type.getReturnType((String)desc);
            boolean bl = hasReturn = returnType != Type.VOID_TYPE;
            if (hasReturn) {
                this.mv.visitInsn(returnType.getSize() == 1 ? 87 : 88);
            }
            Type[] params = Type.getArgumentTypes((String)desc);
            int argSize = params.length;
            int ownerSize = opcode == 184 ? 0 : 1;
            int ssize = this.currentFrame.getStackSize() - argSize - ownerSize;
            for (int i = ssize - 1; i >= 0; --i) {
                BasicValue value = (BasicValue)this.currentFrame.getStack(i);
                if (ContinuationMethodAdapter.isNull(value)) {
                    this.mv.visitInsn(87);
                    continue;
                }
                if (value == BasicValue.UNINITIALIZED_VALUE) continue;
                if (value.isReference()) {
                    this.mv.visitVarInsn(25, this.stackRecorderVar);
                    this.mv.visitInsn(95);
                    this.mv.visitMethodInsn(182, STACK_RECORDER, "pushObject", "(Ljava/lang/Object;)V", false);
                    continue;
                }
                Type type = value.getType();
                if (type.getSize() > 1) {
                    this.mv.visitInsn(1);
                    this.mv.visitVarInsn(25, this.stackRecorderVar);
                    this.mv.visitInsn(94);
                    this.mv.visitInsn(88);
                    this.mv.visitMethodInsn(182, STACK_RECORDER, this.getPushMethod(type), "(" + type.getDescriptor() + ")V", false);
                    this.mv.visitInsn(87);
                    continue;
                }
                this.mv.visitVarInsn(25, this.stackRecorderVar);
                this.mv.visitInsn(95);
                this.mv.visitMethodInsn(182, STACK_RECORDER, this.getPushMethod(type), "(" + type.getDescriptor() + ")V", false);
            }
            if (!this.isStatic) {
                this.mv.visitVarInsn(25, this.stackRecorderVar);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitMethodInsn(182, STACK_RECORDER, "pushReference", "(Ljava/lang/Object;)V", false);
            }
            int fsize = this.currentFrame.getLocals();
            for (int j = 0; j < fsize; ++j) {
                BasicValue value = (BasicValue)this.currentFrame.getLocal(j);
                if (ContinuationMethodAdapter.isNull(value) || value == BasicValue.UNINITIALIZED_VALUE) continue;
                if (value.isReference()) {
                    this.mv.visitVarInsn(25, this.stackRecorderVar);
                    this.mv.visitVarInsn(25, j);
                    this.mv.visitMethodInsn(182, STACK_RECORDER, "pushObject", "(Ljava/lang/Object;)V", false);
                    continue;
                }
                this.mv.visitVarInsn(25, this.stackRecorderVar);
                Type type = value.getType();
                this.mv.visitVarInsn(type.getOpcode(21), j);
                this.mv.visitMethodInsn(182, STACK_RECORDER, this.getPushMethod(type), "(" + type.getDescriptor() + ")V", false);
            }
            this.mv.visitVarInsn(25, this.stackRecorderVar);
            if (this.currentIndex >= 128) {
                this.mv.visitIntInsn(17, this.currentIndex);
            } else {
                this.mv.visitIntInsn(16, this.currentIndex);
            }
            this.mv.visitMethodInsn(182, STACK_RECORDER, "pushInt", "(I)V", false);
            if (this.currentFrame instanceof MonitoringFrame) {
                int[] monitoredLocals;
                for (int monitoredLocal : monitoredLocals = ((MonitoringFrame)this.currentFrame).getMonitored()) {
                    this.mv.visitVarInsn(25, monitoredLocal);
                    this.mv.visitInsn(195);
                }
            }
            Type methodReturnType = Type.getReturnType((String)this.methodDesc);
            this.pushDefault(methodReturnType);
            this.mv.visitInsn(methodReturnType.getOpcode(172));
            this.mv.visitLabel(fl);
            ++this.currentIndex;
            this.currentFrame = null;
        }
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        Label endLabel = new Label();
        this.mv.visitLabel(endLabel);
        this.mv.visitLocalVariable("__stackRecorder", "L" + STACK_RECORDER + ";", null, this.startLabel, endLabel, this.stackRecorderVar);
        this.mv.visitMaxs(0, 0);
    }

    static boolean isNull(BasicValue value) {
        if (null == value) {
            return true;
        }
        if (!value.isReference()) {
            return false;
        }
        Type type = value.getType();
        return "Lnull;".equals(type.getDescriptor());
    }

    void pushDefault(Type type) {
        switch (type.getSort()) {
            case 0: {
                break;
            }
            case 8: {
                this.mv.visitInsn(14);
                break;
            }
            case 7: {
                this.mv.visitInsn(9);
                break;
            }
            case 6: {
                this.mv.visitInsn(11);
                break;
            }
            case 9: 
            case 10: {
                this.mv.visitInsn(1);
                break;
            }
            default: {
                this.mv.visitInsn(3);
            }
        }
    }

    String getPopMethod(Type type) {
        return POP_METHOD + SUFFIXES[type.getSort()];
    }

    String getPushMethod(Type type) {
        return PUSH_METHOD + SUFFIXES[type.getSort()];
    }
}

