/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow;

import java.io.Serializable;
import org.apache.commons.javaflow.ContinuationDeath;
import org.apache.commons.javaflow.bytecode.StackRecorder;
import org.apache.commons.javaflow.utils.ReflectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Continuation
implements Serializable {
    private static final Log log = LogFactory.getLog(Continuation.class);
    private static final long serialVersionUID = 2L;
    public final StackRecorder stackRecorder;

    public Continuation(StackRecorder pStackRecorder) {
        this.stackRecorder = pStackRecorder;
    }

    public static Object getContext() {
        return StackRecorder.get().getContext();
    }

    public static Continuation startSuspendedWith(Runnable pTarget) {
        return new Continuation(new StackRecorder(pTarget));
    }

    public static Continuation startWith(Runnable pTarget) {
        return Continuation.startWith(pTarget, null);
    }

    public static Continuation startWith(Runnable pTarget, Object pContext) {
        if (pTarget == null) {
            throw new IllegalArgumentException("target is null");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("starting new flow from " + ReflectionUtils.getClassName(pTarget) + "/" + ReflectionUtils.getClassLoaderName(pTarget)));
        }
        return Continuation.continueWith(new Continuation(new StackRecorder(pTarget)), pContext);
    }

    public static Continuation continueWith(Continuation pOldContinuation) {
        return Continuation.continueWith(pOldContinuation, null);
    }

    public static Continuation continueWith(Continuation pOldContinuation, Object pContext) {
        if (pOldContinuation == null) {
            throw new IllegalArgumentException("continuation parameter must not be null.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("continueing with continuation " + ReflectionUtils.getClassName(pOldContinuation) + "/" + ReflectionUtils.getClassLoaderName(pOldContinuation)));
        }
        while (true) {
            try {
                StackRecorder pStackRecorder = new StackRecorder(pOldContinuation.stackRecorder).execute(pContext);
                if (pStackRecorder == null) {
                    return null;
                }
                return new Continuation(pStackRecorder);
            }
            catch (ContinuationDeath e) {
                if (e.mode.equals("again")) continue;
                if (e.mode.equals("exit")) {
                    return null;
                }
                if (e.mode.equals("cancel")) {
                    return pOldContinuation;
                }
                throw new IllegalStateException("Illegal mode " + e.mode);
            }
            break;
        }
    }

    public boolean isSerializable() {
        return this.stackRecorder.isSerializable();
    }

    public Object value() {
        return this.stackRecorder.value;
    }

    public static Object suspend() {
        return Continuation.suspend(null);
    }

    public static Object suspend(Object value) {
        return StackRecorder.suspend(value);
    }

    public static void exit() {
        throw new ContinuationDeath("exit");
    }

    public static void again() {
        throw new ContinuationDeath("again");
    }

    public static void cancel() {
        throw new ContinuationDeath("cancel");
    }

    public String toString() {
        return "Continuation@" + this.hashCode() + "/" + ReflectionUtils.getClassLoaderName(this);
    }
}

