/*
 * Decompiled with CFR 0.152.
 */
package jj.play.org.eclipse.mylyn.wikitext.core.parser.util;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.outline.OutlineItem;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.outline.OutlineParser;
import jj.play.org.eclipse.mylyn.wikitext.core.util.DefaultXmlStreamWriter;
import jj.play.org.eclipse.mylyn.wikitext.core.util.FormattingXMLStreamWriter;
import jj.play.org.eclipse.mylyn.wikitext.core.util.XmlStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkupToEclipseToc {
    private String bookTitle;
    private String htmlFile;
    private MarkupLanguage markupLanguage;
    private String helpPrefix;

    public String parse(String markupContent) {
        if (this.markupLanguage == null) {
            throw new IllegalStateException("Must set markupLanguage");
        }
        OutlineParser parser = new OutlineParser(this.markupLanguage);
        OutlineItem root = parser.parse(markupContent);
        return this.createToc(root);
    }

    public String createToc(OutlineItem root) {
        StringWriter out = new StringWriter(8096);
        XmlStreamWriter writer = this.createXmlStreamWriter(out);
        writer.writeStartDocument("utf-8", "1.0");
        writer.writeStartElement("toc");
        writer.writeAttribute("topic", this.adjustForPrefix(this.getHtmlFile()));
        writer.writeAttribute("label", this.getBookTitle());
        this.emitToc(writer, root.getChildren());
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.close();
        return out.toString();
    }

    private void emitToc(XmlStreamWriter writer, List<OutlineItem> children) {
        for (OutlineItem item : children) {
            writer.writeStartElement("topic");
            String file = this.computeFile(item);
            file = this.adjustForPrefix(file);
            String suffix = "";
            OutlineItem previous = item.getPrevious();
            if (previous != null && previous.getParent() != null) {
                String fileOfPrevious = this.computeFile(previous);
                if (file.equals(fileOfPrevious = this.adjustForPrefix(fileOfPrevious))) {
                    suffix = "#" + item.getId();
                }
            }
            writer.writeAttribute("href", String.valueOf(file) + suffix);
            writer.writeAttribute("label", item.getLabel());
            if (!item.getChildren().isEmpty()) {
                this.emitToc(writer, item.getChildren());
            }
            writer.writeEndElement();
        }
    }

    private String adjustForPrefix(String file) {
        if (this.helpPrefix != null) {
            file = this.helpPrefix.endsWith("/") ? String.valueOf(this.helpPrefix) + file : String.valueOf(this.helpPrefix) + '/' + file;
        }
        return file;
    }

    protected String computeFile(OutlineItem item) {
        return this.getHtmlFile();
    }

    public MarkupLanguage getMarkupLanguage() {
        return this.markupLanguage;
    }

    public void setMarkupLanguage(MarkupLanguage markupLanguage) {
        this.markupLanguage = markupLanguage;
    }

    public String getBookTitle() {
        return this.bookTitle;
    }

    public void setBookTitle(String bookTitle) {
        this.bookTitle = bookTitle;
    }

    public String getHtmlFile() {
        return this.htmlFile;
    }

    public void setHtmlFile(String htmlFile) {
        this.htmlFile = htmlFile;
    }

    protected XmlStreamWriter createXmlStreamWriter(Writer out) {
        DefaultXmlStreamWriter writer = new DefaultXmlStreamWriter(out);
        return new FormattingXMLStreamWriter(writer);
    }

    public void setHelpPrefix(String helpPrefix) {
        this.helpPrefix = helpPrefix;
    }
}

