/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.lang.reflect.Method;
import java.util.Map;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.ValidateWithMethod;
import net.sf.oval.context.OValContext;
import net.sf.oval.exception.InvalidConfigurationException;
import net.sf.oval.exception.ReflectionException;
import net.sf.oval.internal.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidateWithMethodCheck
extends AbstractAnnotationCheck<ValidateWithMethod> {
    private static final long serialVersionUID = 1L;
    private boolean ignoreIfNull;
    private String methodName;
    private Class<?> parameterType;

    @Override
    public void configure(ValidateWithMethod constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setMethodName(constraintAnnotation.methodName());
        this.setParameterType(constraintAnnotation.parameterType());
        this.setIgnoreIfNull(constraintAnnotation.ignoreIfNull());
    }

    protected Map<String, String> createMessageVariables() {
        Map<String, String> messageVariables = Validator.getCollectionFactory().createMap(4);
        messageVariables.put("ignoreIfNull", Boolean.toString(this.ignoreIfNull));
        messageVariables.put("methodName", this.methodName);
        messageVariables.put("parameterType", this.parameterType.getName());
        return messageVariables;
    }

    @Override
    protected ConstraintTarget[] getAppliesToDefault() {
        return new ConstraintTarget[]{ConstraintTarget.VALUES};
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class<?> getParameterType() {
        return this.parameterType;
    }

    public boolean isIgnoreIfNull() {
        return this.ignoreIfNull;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, OValContext context, Validator validator) throws ReflectionException {
        if (valueToValidate == null && this.ignoreIfNull) {
            return true;
        }
        Method method = ReflectionUtils.getMethodRecursive(validatedObject.getClass(), this.methodName, this.parameterType);
        if (method == null) {
            throw new InvalidConfigurationException("Method " + validatedObject.getClass().getName() + "." + this.methodName + "(" + this.parameterType + ") not found. Is [" + this.parameterType + "] the correct value for [parameterType]?");
        }
        return (Boolean)ReflectionUtils.invokeMethod(method, validatedObject, valueToValidate);
    }

    public void setIgnoreIfNull(boolean ignoreIfNull) {
        this.ignoreIfNull = ignoreIfNull;
        this.requireMessageVariablesRecreation();
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
        this.requireMessageVariablesRecreation();
    }

    public void setParameterType(Class<?> parameterType) {
        this.parameterType = parameterType;
        this.requireMessageVariablesRecreation();
    }
}

