/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.javascript.FunctionWrapper;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxStaticFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.JavaScriptException;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.NativeObject;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.TopLevel;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass(browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
public class Promise
extends SimpleScriptable {
    private Object value_;
    private Promise[] all_;
    private boolean resolve_ = true;
    private String exceptionDetails_;

    public Promise() {
    }

    public Promise(Window window) {
        this.setParentScope(window);
        this.setPrototype(window.getPrototype(Promise.class));
    }

    @JsxConstructor
    public Promise(Object object) {
        if (object instanceof Promise) {
            this.value_ = ((Promise)object).value_;
        } else if (object instanceof NativeObject) {
            NativeObject nativeObject = (NativeObject)object;
            this.value_ = nativeObject.get("then", (Scriptable)nativeObject);
        } else {
            this.value_ = object;
        }
    }

    @JsxStaticFunction
    public static Promise resolve(Context context, Scriptable thisObj, Object[] args, Function function) {
        Promise promise = new Promise(args.length != 0 ? args[0] : Undefined.instance);
        promise.setResolve(true);
        promise.setParentScope(thisObj.getParentScope());
        promise.setPrototype(Promise.getWindow(thisObj).getPrototype(promise.getClass()));
        return promise;
    }

    @JsxStaticFunction
    public static Promise reject(Context context, Scriptable thisObj, Object[] args, Function function) {
        Promise promise = new Promise(args.length != 0 ? args[0] : Undefined.instance);
        promise.setResolve(false);
        promise.setParentScope(thisObj.getParentScope());
        promise.setPrototype(Promise.getWindow(thisObj).getPrototype(promise.getClass()));
        return promise;
    }

    private void setResolve(boolean resolve) {
        this.resolve_ = resolve;
    }

    private boolean isResolved(Function onRejected) {
        if (this.all_ != null) {
            Object[] values = new Object[this.all_.length];
            for (int i = 0; i < this.all_.length; ++i) {
                Promise p = this.all_[i];
                if (!p.isResolved(onRejected)) {
                    this.value_ = p.value_;
                    return false;
                }
                if (p.value_ instanceof Function) continue;
                values[i] = p.value_;
            }
            NativeArray array = new NativeArray(values);
            ScriptRuntime.setBuiltinProtoAndParent((ScriptableObject)array, (Scriptable)this.getParentScope(), (TopLevel.Builtins)TopLevel.Builtins.Array);
            this.value_ = array;
        }
        return this.resolve_;
    }

    @JsxStaticFunction
    public static Promise all(Context context, Scriptable thisObj, Object[] args, Function function) {
        Promise promise = new Promise();
        promise.setResolve(true);
        if (args.length == 0) {
            promise.all_ = new Promise[0];
        } else {
            NativeArray array = (NativeArray)args[0];
            int length = (int)array.getLength();
            promise.all_ = new Promise[length];
            for (int i = 0; i < length; ++i) {
                Object o = array.get(i);
                promise.all_[i] = o instanceof Promise ? (Promise)o : Promise.resolve(null, thisObj, new Object[]{o}, null);
            }
        }
        promise.setParentScope(thisObj.getParentScope());
        promise.setPrototype(Promise.getWindow(thisObj).getPrototype(promise.getClass()));
        return promise;
    }

    @JsxFunction
    public Promise then(final Function onFulfilled, final Function onRejected) {
        final Window window = this.getWindow();
        final Promise promise = new Promise(window);
        final Promise thisPromise = this;
        PostponedAction thenAction = new PostponedAction(window.getDocument().getPage(), "Promise.then"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() throws Exception {
                Context.enter();
                try {
                    Object newValue;
                    block10: {
                        Function toExecute;
                        newValue = null;
                        Function function = toExecute = Promise.this.isResolved(onRejected) ? onFulfilled : onRejected;
                        if (Promise.this.value_ instanceof Function) {
                            WasCalledFunctionWrapper wrapper = new WasCalledFunctionWrapper(toExecute);
                            try {
                                ((Function)Promise.this.value_).call(Context.getCurrentContext(), (Scriptable)window, (Scriptable)thisPromise, new Object[]{wrapper, onRejected});
                                if (wrapper.wasCalled_) {
                                    newValue = wrapper.value_;
                                }
                                break block10;
                            }
                            catch (JavaScriptException e) {
                                if (onRejected == null) {
                                    promise.exceptionDetails_ = e.details();
                                } else if (!wrapper.wasCalled_) {
                                    newValue = onRejected.call(Context.getCurrentContext(), (Scriptable)window, (Scriptable)thisPromise, new Object[]{e.getValue()});
                                }
                                break block10;
                            }
                        }
                        newValue = toExecute.call(Context.getCurrentContext(), (Scriptable)window, (Scriptable)thisPromise, new Object[]{Promise.this.value_});
                    }
                    promise.value_ = newValue;
                }
                finally {
                    Context.exit();
                }
            }
        };
        JavaScriptEngine jsEngine = window.getWebWindow().getWebClient().getJavaScriptEngine();
        jsEngine.addPostponedAction(thenAction);
        return promise;
    }

    @JsxFunction(functionName="catch")
    public Promise catch_js(final Function onRejected) {
        final Window window = this.getWindow();
        final Promise promise = new Promise(window);
        final Promise thisPromise = this;
        PostponedAction thenAction = new PostponedAction(window.getDocument().getPage(), "Promise.catch"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() throws Exception {
                Context.enter();
                try {
                    Object newValue = onRejected.call(Context.getCurrentContext(), (Scriptable)window, (Scriptable)thisPromise, new Object[]{Promise.this.exceptionDetails_});
                    promise.value_ = newValue;
                }
                finally {
                    Context.exit();
                }
            }
        };
        JavaScriptEngine jsEngine = window.getWebWindow().getWebClient().getJavaScriptEngine();
        jsEngine.addPostponedAction(thenAction);
        return promise;
    }

    private static class WasCalledFunctionWrapper
    extends FunctionWrapper {
        private boolean wasCalled_;
        private Object value_;

        WasCalledFunctionWrapper(Function wrapped) {
            super(wrapped);
        }

        @Override
        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            this.wasCalled_ = true;
            this.value_ = super.call(cx, scope, thisObj, args);
            return this.value_;
        }
    }
}

