/*
 * Decompiled with CFR 0.152.
 */
package jregex;

import jregex.Block;
import jregex.CharacterClass;
import jregex.Term;
import jregex.UnicodeConstants;

class Bitset
implements UnicodeConstants {
    private static final Block[][] categoryBits = new Block[32][256];
    private boolean positive = true;
    private boolean isLarge = false;
    boolean[] block0;
    private static final boolean[] emptyBlock0;
    Block[] blocks;
    private int weight;

    Bitset() {
    }

    final void reset() {
        this.positive = true;
        this.block0 = null;
        this.blocks = null;
        this.isLarge = false;
        this.weight = 0;
    }

    static final void unify(Bitset bitset, Term term) {
        if (bitset.isLarge) {
            term.type = 2;
            term.bitset2 = Block.toBitset2(bitset.blocks);
        } else {
            term.type = 1;
            term.bitset = bitset.block0 == null ? emptyBlock0 : bitset.block0;
        }
        term.inverse = !bitset.positive;
        term.weight = bitset.positive ? bitset.weight : 65536 - bitset.weight;
    }

    final void setPositive(boolean bl) {
        this.positive = bl;
    }

    final boolean isPositive() {
        return this.positive;
    }

    final boolean isLarge() {
        return this.isLarge;
    }

    private final void enableLargeMode() {
        if (this.isLarge) {
            return;
        }
        Block[] blockArray = new Block[256];
        this.blocks = blockArray;
        if (this.block0 != null) {
            blockArray[0] = new Block(this.block0);
        }
        this.isLarge = true;
    }

    final int getWeight() {
        return this.positive ? this.weight : 65536 - this.weight;
    }

    final void setWordChar(boolean bl) {
        if (bl) {
            this.setCategory(1);
            this.setCategory(2);
            this.setCategory(3);
            this.setCategory(5);
            this.setCategory(9);
            this.setChar('_');
        } else {
            this.setRange('a', 'z');
            this.setRange('A', 'Z');
            this.setRange('0', '9');
            this.setChar('_');
        }
    }

    final void setDigit(boolean bl) {
        if (bl) {
            this.setCategory(9);
        } else {
            this.setRange('0', '9');
        }
    }

    final void setSpace(boolean bl) {
        if (bl) {
            this.setCategory(12);
            this.setCategory(14);
            this.setCategory(13);
        } else {
            this.setChar(' ');
            this.setChar('\r');
            this.setChar('\n');
            this.setChar('\t');
            this.setChar('\f');
        }
    }

    final void setCategory(int n) {
        if (!this.isLarge) {
            this.enableLargeMode();
        }
        Block[] blockArray = categoryBits[n];
        this.weight += Block.add(this.blocks, blockArray, 0, 255, false);
    }

    final void setChars(String string) {
        int n = string.length() - 1;
        while (n >= 0) {
            this.setChar(string.charAt(n));
            --n;
        }
    }

    final void setChar(char c) {
        this.setRange(c, c);
    }

    final void setRange(char n, char c) {
        if (c >= '\u0100' || this.isLarge) {
            int n2 = 0;
            if (!this.isLarge) {
                this.enableLargeMode();
            }
            Block[] blockArray = this.blocks;
            int n3 = n;
            while (n3 <= c) {
                int n4 = n3 >> 8 & 0xFF;
                int n5 = n3 & 0xFF;
                Block block = blockArray[n4];
                if (block == null) {
                    blockArray[n4] = block = new Block();
                }
                if (block.set(n5)) {
                    ++n2;
                }
                ++n3;
            }
            this.weight += n2;
        } else {
            boolean[] blArray = this.block0;
            if (blArray == null) {
                this.block0 = blArray = new boolean[256];
            }
            this.weight += Bitset.set(blArray, true, n, c);
        }
    }

    final void add(Bitset bitset) {
        this.add(bitset, false);
    }

    final void add(Bitset bitset, boolean bl) {
        this.weight += Bitset.addImpl(this, bitset, !bitset.positive ^ bl);
    }

    private static final int addImpl(Bitset bitset, Bitset bitset2, boolean bl) {
        int n = 0;
        if (!(bitset.isLarge || bitset2.isLarge || bl)) {
            if (bitset2.block0 != null) {
                boolean[] blArray = bitset.block0;
                if (blArray == null) {
                    bitset.block0 = blArray = new boolean[256];
                }
                n += Bitset.add(blArray, bitset2.block0, 0, 255, false);
            }
        } else {
            if (!bitset.isLarge) {
                bitset.enableLargeMode();
            }
            if (!bitset2.isLarge) {
                bitset2.enableLargeMode();
            }
            n += Block.add(bitset.blocks, bitset2.blocks, 0, 255, bl);
        }
        return n;
    }

    final void subtract(Bitset bitset) {
        this.subtract(bitset, false);
    }

    final void subtract(Bitset bitset, boolean bl) {
        this.weight += Bitset.subtractImpl(this, bitset, !bitset.positive ^ bl);
    }

    private static final int subtractImpl(Bitset bitset, Bitset bitset2, boolean bl) {
        int n = 0;
        if (!(bitset.isLarge || bitset2.isLarge || bl)) {
            boolean[] blArray = bitset2.block0;
            if (bitset2.block0 != null) {
                boolean[] blArray2 = bitset.block0;
                if (blArray2 == null) {
                    return 0;
                }
                n += Bitset.subtract(blArray2, blArray, 0, 255, false);
            }
        } else {
            if (!bitset.isLarge) {
                bitset.enableLargeMode();
            }
            if (!bitset2.isLarge) {
                bitset2.enableLargeMode();
            }
            n += Block.subtract(bitset.blocks, bitset2.blocks, 0, 255, bl);
        }
        return n;
    }

    final void intersect(Bitset bitset) {
        this.intersect(bitset, false);
    }

    final void intersect(Bitset bitset, boolean bl) {
        this.subtract(bitset, !bl);
    }

    static final int add(boolean[] blArray, boolean[] blArray2, int n, int n2, boolean bl) {
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            if (!blArray[n4] && blArray2[n4] ^ bl) {
                ++n3;
                blArray[n4] = true;
            }
            ++n4;
        }
        return n3;
    }

    static final int subtract(boolean[] blArray, boolean[] blArray2, int n, int n2, boolean bl) {
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            if (blArray[n4] && blArray2[n4] ^ bl) {
                --n3;
                blArray[n4] = false;
            }
            ++n4;
        }
        return n3;
    }

    static final int set(boolean[] blArray, boolean bl, int n, int n2) {
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            if (blArray[n4] != bl) {
                n3 = bl ? ++n3 : --n3;
                blArray[n4] = bl;
            }
            ++n4;
        }
        return n3;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.positive) {
            stringBuffer.append('^');
        }
        if (this.isLarge) {
            stringBuffer.append(CharacterClass.stringValue2(Block.toBitset2(this.blocks)));
        } else if (this.block0 != null) {
            stringBuffer.append(CharacterClass.stringValue0(this.block0));
        }
        stringBuffer.append('(');
        stringBuffer.append(this.getWeight());
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    static {
        int n = 0;
        while (n <= 65535) {
            int n2;
            int n3 = Character.getType((char)n);
            Block block = categoryBits[n3][n2 = n >> 8 & 0xFF];
            if (block == null) {
                Bitset.categoryBits[n3][n2] = block = new Block();
            }
            block.set(n & 0xFF);
            ++n;
        }
        emptyBlock0 = new boolean[256];
    }
}

