/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.com.jhlabs.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.io.Serializable;
import jj.play.ns.com.jhlabs.image.ImageMath;

public class TileImageFilter
extends ImageFilter
implements Serializable {
    static final long serialVersionUID = 4926390225069192478L;
    public static final int FLIP_NONE = 0;
    public static final int FLIP_H = 1;
    public static final int FLIP_V = 2;
    public static final int FLIP_HV = 3;
    public static final int FLIP_180 = 4;
    private int width;
    private int height;
    private int tileWidth;
    private int tileHeight;
    private int edge = 0;
    private int cols;
    private int rows;
    private int[][] symmetryMatrix = null;
    private int symmetryRows = 2;
    private int symmetryCols = 2;

    public TileImageFilter() {
        this(32, 32);
    }

    public TileImageFilter(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setDimensions(int n, int n2) {
        this.consumer.setDimensions(this.width, this.height);
        this.tileWidth = n - this.edge;
        this.tileHeight = n2 - this.edge;
        this.cols = (this.width + this.tileWidth - 1) / this.tileWidth;
        this.rows = (this.height + this.tileHeight - 1) / this.tileHeight;
    }

    public void setHints(int n) {
        n &= 0xFFFFFFFD;
        n &= 0xFFFFFFFB;
        this.consumer.setHints(n |= 1);
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int n7 = 0;
        while (n7 < this.rows) {
            int n8 = Math.min(n4, this.height - n2);
            if (n8 > 0) {
                int n9 = n;
                int n10 = 0;
                while (n10 < this.cols) {
                    int n11 = Math.min(n3, this.width - n);
                    if (n11 > 0) {
                        this.consumer.setPixels(n9, n2, n11, n8, colorModel, byArray, n5, n6);
                    }
                    n9 += this.tileWidth;
                    ++n10;
                }
            }
            n2 += this.tileHeight;
            ++n7;
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        if (this.edge > 0) {
            nArray = this.blendPixels(n, n2, n3, n4, nArray, n5, n6);
        }
        int n7 = 0;
        while (n7 < this.rows) {
            int n8 = Math.min(n4, this.height - n2);
            if (n8 > 0) {
                int n9 = n;
                int n10 = 0;
                while (n10 < this.cols) {
                    int n11 = Math.min(n3, this.width - n);
                    if (n11 > 0) {
                        if (this.symmetryMatrix != null) {
                            this.consumer.setPixels(n9, n2, n11, n8, colorModel, this.flipPixels(n, n2, n3, n4, nArray, n5, n6, this.symmetryMatrix[n10 % this.symmetryCols][n7 % this.symmetryRows]), n5, n6);
                        } else {
                            this.consumer.setPixels(n9, n2, n11, n8, colorModel, nArray, n5, n6);
                        }
                    }
                    n9 += this.tileWidth;
                    ++n10;
                }
            }
            n2 += this.tileHeight;
            ++n7;
        }
    }

    public int[] blendPixels(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        int[] nArray2 = new int[n3 * n4];
        int n7 = 8;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n4) {
            int n10 = 0;
            while (n10 < n3) {
                if (n9 < n7 || n10 < n7) {
                    double d;
                    int n11;
                    int n12 = n9 < n7 ? n4 - n7 - 1 + n9 : n9;
                    int n13 = n11 = n10 < n7 ? n3 - n7 - 1 + n10 : n10;
                    if (n9 < n7 && n10 < n7) {
                        d = (double)n9 / (double)n7;
                        double d2 = (double)n10 / (double)n7;
                        int n14 = n12 * n3 + n11;
                        int n15 = n9 * n3 + n11;
                        int n16 = n12 * n3 + n10;
                        int n17 = ImageMath.mixColors(d, nArray[n16], nArray[n8]);
                        int n18 = ImageMath.mixColors(d, nArray[n14], nArray[n15]);
                        nArray2[n8] = ImageMath.mixColors(d2, n18, n17);
                    } else {
                        d = (double)Math.min(n9, n10) / (double)n7;
                        int n19 = n12 * n3 + n11;
                        nArray2[n8] = ImageMath.mixColors(d, nArray[n19], nArray[n8]);
                    }
                } else {
                    nArray2[n8] = nArray[n8];
                }
                ++n8;
                ++n10;
            }
            ++n9;
        }
        return nArray2;
    }

    public void setSymmetryMatrix(int[][] nArray) {
        this.symmetryMatrix = nArray;
        this.symmetryRows = nArray.length;
        this.symmetryCols = nArray[0].length;
    }

    public int[][] getSymmetryMatrix() {
        return this.symmetryMatrix;
    }

    public int[] flipPixels(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6, int n7) {
        int n8 = n;
        int n9 = n2;
        int n10 = n3;
        int n11 = n4;
        switch (n7) {
            case 1: {
                n8 = this.width - (n + n3);
                break;
            }
            case 2: {
                n9 = this.height - (n2 + n4);
                break;
            }
            case 3: {
                n10 = n4;
                n11 = n3;
                n8 = n2;
                n9 = n;
                break;
            }
            case 4: {
                n8 = this.width - (n + n3);
                n9 = this.height - (n2 + n4);
                break;
            }
        }
        int[] nArray2 = new int[n10 * n11];
        int n12 = 0;
        while (n12 < n4) {
            int n13 = 0;
            while (n13 < n3) {
                int n14 = n12 * n6 + n5 + n13;
                int n15 = n12;
                int n16 = n13;
                switch (n7) {
                    case 1: {
                        n16 = n3 - n13 - 1;
                        break;
                    }
                    case 2: {
                        n15 = n4 - n12 - 1;
                        break;
                    }
                    case 3: {
                        n15 = n13;
                        n16 = n12;
                        break;
                    }
                    case 4: {
                        n15 = n4 - n12 - 1;
                        n16 = n3 - n13 - 1;
                        break;
                    }
                }
                int n17 = n15 * n10 + n16;
                nArray2[n17] = nArray[n14];
                ++n13;
            }
            ++n12;
        }
        return nArray2;
    }

    public String toString() {
        return "Tile";
    }
}

