/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.com.jhlabs.image;

import java.awt.Rectangle;
import jj.play.ns.com.jhlabs.image.GaussianFilter;
import jj.play.ns.com.jhlabs.image.Kernel;
import jj.play.ns.com.jhlabs.image.PixelUtils;
import jj.play.ns.com.jhlabs.image.WholeImageFilter;

public class ShadowFilter
extends WholeImageFilter {
    static final long serialVersionUID = 6310370419462785691L;
    private int radius = 5;
    private int xOffset = 5;
    private int yOffset = 5;
    private int opacity = 255;
    private int shadowColor = -16777216;

    public void setXOffset(int n) {
        this.xOffset = n;
    }

    public int getXOffset() {
        return this.xOffset;
    }

    public void setYOffset(int n) {
        this.yOffset = n;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void setRadius(int n) {
        this.radius = n;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setOpacity(int n) {
        this.opacity = n;
    }

    public int getOpacity() {
        return this.opacity;
    }

    public void setShadowColor(int n) {
        this.shadowColor = n;
    }

    public int getShadowColor() {
        return this.shadowColor;
    }

    protected void transformSpace(Rectangle rectangle) {
        rectangle.width += Math.abs(this.xOffset) + 2 * this.radius;
        rectangle.height += Math.abs(this.yOffset) + 2 * this.radius;
    }

    public void imageComplete(int n) {
        try {
            int n2;
            if (n == 1 || n == 4) {
                this.consumer.imageComplete(n);
                return;
            }
            int n3 = this.originalSpace.width;
            int n4 = this.originalSpace.height;
            int n5 = this.transformedSpace.width;
            int n6 = this.transformedSpace.height;
            int[] nArray = new int[n5 * n6];
            int n7 = 0;
            int n8 = 0;
            int n9 = this.opacity << 24 & 0xFF000000;
            n9 |= this.shadowColor & 0xFFFFFF;
            int n10 = this.radius / 2;
            int n11 = Math.max(this.yOffset, n10) + n10;
            int n12 = Math.max(this.xOffset, n10) + n10;
            n7 = 0;
            int n13 = 0;
            while (n13 < n4) {
                n8 = (n11 + n13) * n5 + n12;
                int n14 = 0;
                while (n14 < n3) {
                    n2 = this.inPixels[n7++] >> 24 & 0xFF;
                    nArray[n8++] = n2 != 0 ? n9 : n9 & 0xFFFFFF;
                    ++n14;
                }
                ++n13;
            }
            if (this.radius > 0) {
                Kernel kernel = GaussianFilter.makeKernel(this.radius);
                double[] dArray = kernel.matrix;
                int n15 = kernel.rows;
                int n16 = kernel.cols;
                int n17 = n15 / 2;
                int n18 = n16 / 2;
                int n19 = 0;
                int[] nArray2 = new int[n5 * n6];
                int n20 = 0;
                while (n20 < n6) {
                    int n21 = 0;
                    while (n21 < n5) {
                        int n22;
                        double d = 0.0;
                        double d2 = 0.0;
                        double d3 = 0.0;
                        double d4 = 0.0;
                        int n23 = -n17;
                        while (n23 <= n17) {
                            n22 = n20 + n23;
                            int n24 = n22 >= 0 && n22 < n6 ? n22 * n5 : n20 * n5;
                            int n25 = n16 * (n23 + n17) + n18;
                            int n26 = -n18;
                            while (n26 <= n18) {
                                int n27 = n21 + n26;
                                if (n27 < 0 || n27 >= n5) {
                                    n27 = n21;
                                }
                                int n28 = nArray[n24 + n27];
                                double d5 = dArray[n25 + n26];
                                if (d5 != 0.0) {
                                    d4 += d5 * (double)(n28 >> 24 & 0xFF);
                                }
                                ++n26;
                            }
                            ++n23;
                        }
                        n22 = PixelUtils.clamp((int)d4);
                        nArray2[n19] = n22 << 24 | this.shadowColor & 0xFFFFFF;
                        ++n19;
                        ++n21;
                    }
                    ++n20;
                }
                nArray = nArray2;
                nArray2 = null;
            }
            n7 = 0;
            int n29 = 0;
            while (n29 < n4) {
                n8 = (n11 + n29 - this.yOffset) * n5 + n12 - this.xOffset;
                n2 = 0;
                while (n2 < n3) {
                    nArray[n8] = PixelUtils.combinePixels(this.inPixels[n7], nArray[n8], 1);
                    ++n7;
                    ++n8;
                    ++n2;
                }
                ++n29;
            }
            this.consumer.setPixels(0, 0, n5, n6, this.defaultRGBModel, nArray, 0, n5);
            this.consumer.imageComplete(n);
            this.inPixels = null;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public String toString() {
        return "Stylize/Drop Shadow...";
    }
}

