/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.com.jhlabs.image;

import java.io.PrintStream;
import java.util.Vector;
import jj.play.ns.com.jhlabs.image.Quantizer;

public class OctTreeQuantizer
implements Quantizer {
    static final int MAX_LEVEL = 5;
    private int nodes = 0;
    private OctTreeNode root;
    private int reduceColors;
    private int maximumColors;
    private int colors = 0;
    private Vector[] colorList;

    public OctTreeQuantizer() {
        this.setup(256);
        this.colorList = new Vector[6];
        int n = 0;
        while (n < 6) {
            this.colorList[n] = new Vector();
            ++n;
        }
        this.root = new OctTreeNode();
    }

    public void setup(int n) {
        this.maximumColors = n;
        this.reduceColors = Math.max(512, n * 2);
    }

    public void addPixels(int[] nArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            this.insertColor(nArray[n3 + n]);
            if (this.colors > this.reduceColors) {
                this.reduceTree(this.reduceColors);
            }
            ++n3;
        }
    }

    public int getIndexForColor(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        OctTreeNode octTreeNode = this.root;
        int n5 = 0;
        while (n5 <= 5) {
            OctTreeNode octTreeNode2;
            int n6 = 128 >> n5;
            int n7 = 0;
            if ((n2 & n6) != 0) {
                n7 += 4;
            }
            if ((n3 & n6) != 0) {
                n7 += 2;
            }
            if ((n4 & n6) != 0) {
                ++n7;
            }
            if ((octTreeNode2 = octTreeNode.leaf[n7]) == null) {
                return octTreeNode.index;
            }
            if (octTreeNode2.isLeaf) {
                return octTreeNode2.index;
            }
            octTreeNode = octTreeNode2;
            ++n5;
        }
        System.out.println("getIndexForColor failed");
        return 0;
    }

    private void insertColor(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        OctTreeNode octTreeNode = this.root;
        int n5 = 0;
        while (n5 <= 5) {
            OctTreeNode octTreeNode2;
            int n6 = 128 >> n5;
            int n7 = 0;
            if ((n2 & n6) != 0) {
                n7 += 4;
            }
            if ((n3 & n6) != 0) {
                n7 += 2;
            }
            if ((n4 & n6) != 0) {
                ++n7;
            }
            if ((octTreeNode2 = octTreeNode.leaf[n7]) == null) {
                ++octTreeNode.children;
                octTreeNode2 = new OctTreeNode();
                octTreeNode2.parent = octTreeNode;
                octTreeNode.leaf[n7] = octTreeNode2;
                octTreeNode.isLeaf = false;
                ++this.nodes;
                this.colorList[n5].addElement(octTreeNode2);
                if (n5 == 5) {
                    octTreeNode2.isLeaf = true;
                    octTreeNode2.count = 1;
                    octTreeNode2.totalRed = n2;
                    octTreeNode2.totalGreen = n3;
                    octTreeNode2.totalBlue = n4;
                    octTreeNode2.level = n5;
                    ++this.colors;
                    return;
                }
                octTreeNode = octTreeNode2;
            } else {
                if (octTreeNode2.isLeaf) {
                    ++octTreeNode2.count;
                    octTreeNode2.totalRed += n2;
                    octTreeNode2.totalGreen += n3;
                    octTreeNode2.totalBlue += n4;
                    return;
                }
                octTreeNode = octTreeNode2;
            }
            ++n5;
        }
        System.out.println("insertColor failed");
    }

    private void reduceTree(int n) {
        int n2 = 4;
        while (n2 >= 0) {
            Vector vector = this.colorList[n2];
            if (vector != null && vector.size() > 0) {
                int n3 = 0;
                while (n3 < vector.size()) {
                    OctTreeNode octTreeNode = (OctTreeNode)vector.elementAt(n3);
                    if (octTreeNode.children > 0) {
                        int n4 = 0;
                        while (n4 < 8) {
                            OctTreeNode octTreeNode2 = octTreeNode.leaf[n4];
                            if (octTreeNode2 != null) {
                                if (!octTreeNode2.isLeaf) {
                                    System.out.println("not a leaf!");
                                }
                                octTreeNode.count += octTreeNode2.count;
                                octTreeNode.totalRed += octTreeNode2.totalRed;
                                octTreeNode.totalGreen += octTreeNode2.totalGreen;
                                octTreeNode.totalBlue += octTreeNode2.totalBlue;
                                octTreeNode.leaf[n4] = null;
                                --octTreeNode.children;
                                --this.colors;
                                --this.nodes;
                                this.colorList[n2 + 1].removeElement(octTreeNode2);
                            }
                            ++n4;
                        }
                        octTreeNode.isLeaf = true;
                        ++this.colors;
                        if (this.colors <= n) {
                            return;
                        }
                    }
                    ++n3;
                }
            }
            --n2;
        }
        System.out.println("Unable to reduce the OctTree");
    }

    public int[] buildColorTable() {
        int[] nArray = new int[this.colors];
        this.buildColorTable(this.root, nArray, 0);
        return nArray;
    }

    public void buildColorTable(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        this.maximumColors = nArray2.length;
        int n2 = 0;
        while (n2 < n) {
            this.insertColor(nArray[n2]);
            if (this.colors > this.reduceColors) {
                this.reduceTree(this.reduceColors);
            }
            ++n2;
        }
        if (this.colors > this.maximumColors) {
            this.reduceTree(this.maximumColors);
        }
        this.buildColorTable(this.root, nArray2, 0);
    }

    private int buildColorTable(OctTreeNode octTreeNode, int[] nArray, int n) {
        if (this.colors > this.maximumColors) {
            this.reduceTree(this.maximumColors);
        }
        if (octTreeNode.isLeaf) {
            int n2 = octTreeNode.count;
            nArray[n] = 0xFF000000 | octTreeNode.totalRed / n2 << 16 | octTreeNode.totalGreen / n2 << 8 | octTreeNode.totalBlue / n2;
            octTreeNode.index = n++;
        } else {
            int n3 = 0;
            while (n3 < 8) {
                if (octTreeNode.leaf[n3] != null) {
                    octTreeNode.index = n;
                    n = this.buildColorTable(octTreeNode.leaf[n3], nArray, n);
                }
                ++n3;
            }
        }
        return n;
    }

    class OctTreeNode {
        int children;
        int level;
        OctTreeNode parent;
        OctTreeNode[] leaf = new OctTreeNode[8];
        boolean isLeaf;
        int count;
        int totalRed;
        int totalGreen;
        int totalBlue;
        int index;

        public void list(PrintStream printStream, int n) {
            int n2 = 0;
            while (n2 < n) {
                System.out.print(' ');
                ++n2;
            }
            if (this.count == 0) {
                System.out.println(String.valueOf(this.index) + ": count=" + this.count);
            } else {
                System.out.println(String.valueOf(this.index) + ": count=" + this.count + " red=" + this.totalRed / this.count + " green=" + this.totalGreen / this.count + " blue=" + this.totalBlue / this.count);
            }
            int n3 = 0;
            while (n3 < 8) {
                if (this.leaf[n3] != null) {
                    this.leaf[n3].list(printStream, n + 2);
                }
                ++n3;
            }
        }

        OctTreeNode() {
        }
    }
}

