/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.com.jhlabs.image;

import java.awt.image.RGBImageFilter;
import java.io.Serializable;
import jj.play.ns.com.jhlabs.image.Colormap;
import jj.play.ns.com.jhlabs.image.PixelUtils;
import jj.play.ns.com.jhlabs.math.Noise;

public class MarbleTexFilter
extends RGBImageFilter
implements Serializable {
    private double scale = 32.0;
    private double stretch = 1.0;
    private double angle = 0.0;
    private double turbulence = 1.0;
    private double turbulenceFactor = 0.5;
    private Colormap colormap;
    private double m00 = 1.0;
    private double m01 = 0.0;
    private double m10 = 0.0;
    private double m11 = 1.0;

    public void setScale(double d) {
        this.scale = d;
    }

    public double getScale() {
        return this.scale;
    }

    public void setStretch(double d) {
        this.stretch = d;
    }

    public double getStretch() {
        return this.stretch;
    }

    public void setAngle(double d) {
        this.angle = d;
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        this.m00 = d2;
        this.m01 = d3;
        this.m10 = -d3;
        this.m11 = d2;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setTurbulence(double d) {
        this.turbulence = d;
    }

    public double getTurbulence() {
        return this.turbulence;
    }

    public void setTurbulenceFactor(double d) {
        this.turbulenceFactor = d;
    }

    public double getTurbulenceFactor() {
        return this.turbulenceFactor;
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public int filterRGB(int n, int n2, int n3) {
        double d;
        double d2 = this.m00 * (double)n + this.m01 * (double)n2;
        double d3 = this.m10 * (double)n + this.m11 * (double)n2;
        d2 /= this.scale * this.stretch;
        d3 /= this.scale;
        int n4 = n3 & 0xFF000000;
        if (this.colormap != null) {
            double d4 = this.turbulenceFactor * Noise.turbulence2(d2, d3, this.turbulence);
            double d5 = 3.0 * this.turbulenceFactor * d4 + d3;
            d5 = Math.sin(d5 * Math.PI);
            double d6 = Math.sin(40.0 * d4);
            return this.colormap.getColor(d5 += 0.2 * d6);
        }
        double d7 = this.turbulenceFactor * Noise.turbulence2(d2, d3, this.turbulence);
        double d8 = Math.sin(Math.sin(8.0 * d7 + 7.0 * d2 + 3.0 * d3));
        double d9 = d = Math.abs(d8);
        double d10 = Math.sin(40.0 * d7);
        d10 = Math.abs(d10);
        double d11 = 0.6 * d10 + 0.3;
        double d12 = 0.2 * d10 + 0.8;
        double d13 = 0.15 * d10 + 0.85;
        double d14 = 0.5 * Math.pow(Math.abs(d), 0.3);
        d = Math.pow(0.5 * (d + 1.0), 0.6) * d11;
        d9 = Math.pow(0.5 * (d9 + 1.0), 0.6) * d12;
        double d15 = (0.5 * d + 0.35 * d9) * 2.0 * d14;
        double d16 = (0.25 * d + 0.35 * d9) * 2.0 * d14;
        int n5 = n3 >> 16 & 0xFF;
        int n6 = n3 >> 8 & 0xFF;
        int n7 = n3 & 0xFF;
        n5 = PixelUtils.clamp((int)((double)n5 * d15));
        n6 = PixelUtils.clamp((int)((double)n6 * (d14 *= Math.max(d, d9) * d13)));
        n7 = PixelUtils.clamp((int)((double)n7 * d16));
        return n3 & 0xFF000000 | n5 << 16 | n6 << 8 | n7;
    }

    public String toString() {
        return "Texture/Marble Texture...";
    }
}

