/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.com.jhlabs.image;

public class ImageMath {
    private static final double m00 = -0.5;
    private static final double m01 = 1.5;
    private static final double m02 = -1.5;
    private static final double m03 = 0.5;
    private static final double m10 = 1.0;
    private static final double m11 = -2.5;
    private static final double m12 = 2.0;
    private static final double m13 = -0.5;
    private static final double m20 = -0.5;
    private static final double m21 = 0.0;
    private static final double m22 = 0.5;
    private static final double m23 = 0.0;
    private static final double m30 = 0.0;
    private static final double m31 = 1.0;
    private static final double m32 = 0.0;
    private static final double m33 = 0.0;

    public static double bias(double d, double d2) {
        return Math.pow(d, Math.log(d2) / Math.log(0.5));
    }

    public static double gain(double d, double d2) {
        double d3 = Math.log(1.0 - d2) / Math.log(0.5);
        if (d < 0.001) {
            return 0.0;
        }
        if (d > 0.999) {
            return 1.0;
        }
        if (d < 0.5) {
            return Math.pow(2.0 * d, d3) / 2.0;
        }
        return 1.0 - Math.pow(2.0 * (1.0 - d), d3) / 2.0;
    }

    public static double step(double d, double d2) {
        return d2 < d ? 0.0 : 1.0;
    }

    public static double pulse(double d, double d2, double d3) {
        return d3 < d || d3 >= d2 ? 0.0 : 1.0;
    }

    public static double smoothPulse(double d, double d2, double d3, double d4, double d5) {
        if (d5 < d || d5 >= d4) {
            return 0.0;
        }
        if (d5 >= d2) {
            if (d5 < d3) {
                return 1.0;
            }
            d5 = (d5 - d3) / (d4 - d3);
            return 1.0 - d5 * d5 * (3.0 - 2.0 * d5);
        }
        d5 = (d5 - d) / (d2 - d);
        return d5 * d5 * (3.0 - 2.0 * d5);
    }

    public static double smoothStep(double d, double d2, double d3) {
        if (d3 < d) {
            return 0.0;
        }
        if (d3 >= d2) {
            return 1.0;
        }
        d3 = (d3 - d) / (d2 - d);
        return d3 * d3 * (3.0 - 2.0 * d3);
    }

    public static double circleUp(double d) {
        d = 1.0 - d;
        return Math.sqrt(1.0 - d * d);
    }

    public static double circleDown(double d) {
        return 1.0 - Math.sqrt(1.0 - d * d);
    }

    public static double clamp(double d, double d2, double d3) {
        return d < d2 ? d2 : (d > d3 ? d3 : d);
    }

    public static int clamp(int n, int n2, int n3) {
        return n < n2 ? n2 : (n > n3 ? n3 : n);
    }

    public static double mod(double d, double d2) {
        int n;
        if ((d -= (double)(n = (int)(d / d2)) * d2) < 0.0) {
            return d + d2;
        }
        return d;
    }

    public static int mod(int n, int n2) {
        int n3;
        if ((n -= (n3 = n / n2) * n2) < 0) {
            return n + n2;
        }
        return n;
    }

    public static double triangle(double d) {
        double d2 = ImageMath.mod(d, 1.0);
        return 2.0 * (d2 < 0.5 ? d2 : 1.0 - d2);
    }

    public static double lerp(double d, double d2, double d3) {
        return d2 + d * (d3 - d2);
    }

    public static int lerp(double d, int n, int n2) {
        return (int)((double)n + d * (double)(n2 - n));
    }

    public static int mixColors(double d, int n, int n2) {
        int n3 = n >> 24 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 8 & 0xFF;
        int n6 = n & 0xFF;
        int n7 = n2 >> 24 & 0xFF;
        int n8 = n2 >> 16 & 0xFF;
        int n9 = n2 >> 8 & 0xFF;
        int n10 = n2 & 0xFF;
        n3 = ImageMath.lerp(d, n3, n7);
        n4 = ImageMath.lerp(d, n4, n8);
        n5 = ImageMath.lerp(d, n5, n9);
        n6 = ImageMath.lerp(d, n6, n10);
        return n3 << 24 | n4 << 16 | n5 << 8 | n6;
    }

    public static int bilinearInterpolate(double d, double d2, int[] nArray) {
        int n = nArray[0] >> 24 & 0xFF;
        int n2 = nArray[0] >> 16 & 0xFF;
        int n3 = nArray[0] >> 8 & 0xFF;
        int n4 = nArray[0] & 0xFF;
        int n5 = nArray[1] >> 24 & 0xFF;
        int n6 = nArray[1] >> 16 & 0xFF;
        int n7 = nArray[1] >> 8 & 0xFF;
        int n8 = nArray[1] & 0xFF;
        int n9 = nArray[2] >> 24 & 0xFF;
        int n10 = nArray[2] >> 16 & 0xFF;
        int n11 = nArray[2] >> 8 & 0xFF;
        int n12 = nArray[2] & 0xFF;
        int n13 = nArray[3] >> 24 & 0xFF;
        int n14 = nArray[3] >> 16 & 0xFF;
        int n15 = nArray[3] >> 8 & 0xFF;
        int n16 = nArray[3] & 0xFF;
        double d3 = 1.0 - d;
        double d4 = 1.0 - d2;
        double d5 = d3 * (double)n + d * (double)n5;
        double d6 = d3 * (double)n9 + d * (double)n13;
        int n17 = (int)(d4 * d5 + d2 * d6);
        d5 = d3 * (double)n2 + d * (double)n6;
        d6 = d3 * (double)n10 + d * (double)n14;
        int n18 = (int)(d4 * d5 + d2 * d6);
        d5 = d3 * (double)n3 + d * (double)n7;
        d6 = d3 * (double)n11 + d * (double)n15;
        int n19 = (int)(d4 * d5 + d2 * d6);
        d5 = d3 * (double)n4 + d * (double)n8;
        d6 = d3 * (double)n12 + d * (double)n16;
        int n20 = (int)(d4 * d5 + d2 * d6);
        return n17 << 24 | n18 << 16 | n19 << 8 | n20;
    }

    public static int brightnessNTSC(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        return (int)((double)n2 * 0.3 + (double)n3 * 0.59 + (double)n4 * 0.11);
    }

    public static double spline(double d, int n, double[] dArray) {
        int n2 = n - 3;
        if (n2 < 1) {
            throw new IllegalArgumentException("Too few knots in spline");
        }
        int n3 = (int)(d = ImageMath.clamp(d, 0.0, 1.0) * (double)n2);
        if (n3 > n - 4) {
            n3 = n - 4;
        }
        d -= (double)n3;
        double d2 = dArray[n3];
        double d3 = dArray[n3 + 1];
        double d4 = dArray[n3 + 2];
        double d5 = dArray[n3 + 3];
        double d6 = -0.5 * d2 + 1.5 * d3 + -1.5 * d4 + 0.5 * d5;
        double d7 = d2 + -2.5 * d3 + 2.0 * d4 + -0.5 * d5;
        double d8 = -0.5 * d2 + 0.0 * d3 + 0.5 * d4 + 0.0 * d5;
        double d9 = 0.0 * d2 + d3 + 0.0 * d4 + 0.0 * d5;
        return ((d6 * d + d7) * d + d8) * d + d9;
    }

    public static double spline(double d, int n, int[] nArray, int[] nArray2) {
        int n2 = n - 3;
        if (n2 < 1) {
            throw new IllegalArgumentException("Too few knots in spline");
        }
        int n3 = 0;
        while (n3 < n2) {
            if ((double)nArray[n3 + 1] > d) break;
            ++n3;
        }
        if (n3 > n - 3) {
            n3 = n - 3;
        }
        double d2 = (d - (double)nArray[n3]) / (double)(nArray[n3 + 1] - nArray[n3]);
        if (--n3 < 0) {
            n3 = 0;
            d2 = 0.0;
        }
        double d3 = nArray2[n3];
        double d4 = nArray2[n3 + 1];
        double d5 = nArray2[n3 + 2];
        double d6 = nArray2[n3 + 3];
        double d7 = -0.5 * d3 + 1.5 * d4 + -1.5 * d5 + 0.5 * d6;
        double d8 = d3 + -2.5 * d4 + 2.0 * d5 + -0.5 * d6;
        double d9 = -0.5 * d3 + 0.0 * d4 + 0.5 * d5 + 0.0 * d6;
        double d10 = 0.0 * d3 + d4 + 0.0 * d5 + 0.0 * d6;
        return ((d7 * d2 + d8) * d2 + d9) * d2 + d10;
    }

    public static int colorSpline(double d, int n, int[] nArray) {
        int n2 = n - 3;
        if (n2 < 1) {
            throw new IllegalArgumentException("Too few knots in spline");
        }
        int n3 = (int)(d = ImageMath.clamp(d, 0.0, 1.0) * (double)n2);
        if (n3 > n - 4) {
            n3 = n - 4;
        }
        d -= (double)n3;
        int n4 = 0;
        int n5 = 0;
        while (n5 < 4) {
            int n6 = n5 * 8;
            double d2 = nArray[n3] >> n6 & 0xFF;
            double d3 = nArray[n3 + 1] >> n6 & 0xFF;
            double d4 = nArray[n3 + 2] >> n6 & 0xFF;
            double d5 = nArray[n3 + 3] >> n6 & 0xFF;
            double d6 = -0.5 * d2 + 1.5 * d3 + -1.5 * d4 + 0.5 * d5;
            double d7 = d2 + -2.5 * d3 + 2.0 * d4 + -0.5 * d5;
            double d8 = -0.5 * d2 + 0.0 * d3 + 0.5 * d4 + 0.0 * d5;
            double d9 = 0.0 * d2 + d3 + 0.0 * d4 + 0.0 * d5;
            int n7 = (int)(((d6 * d + d7) * d + d8) * d + d9);
            if (n7 < 0) {
                n7 = 0;
            } else if (n7 > 255) {
                n7 = 255;
            }
            n4 |= n7 << n6;
            ++n5;
        }
        return n4;
    }

    public static int colorSpline(int n, int n2, int[] nArray, int[] nArray2) {
        int n3 = n2 - 3;
        if (n3 < 1) {
            throw new IllegalArgumentException("Too few knots in spline");
        }
        int n4 = 0;
        while (n4 < n3) {
            if (nArray[n4 + 1] > n) break;
            ++n4;
        }
        if (n4 > n2 - 3) {
            n4 = n2 - 3;
        }
        double d = (double)(n - nArray[n4]) / (double)(nArray[n4 + 1] - nArray[n4]);
        if (--n4 < 0) {
            n4 = 0;
            d = 0.0;
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < 4) {
            int n7 = n6 * 8;
            double d2 = nArray2[n4] >> n7 & 0xFF;
            double d3 = nArray2[n4 + 1] >> n7 & 0xFF;
            double d4 = nArray2[n4 + 2] >> n7 & 0xFF;
            double d5 = nArray2[n4 + 3] >> n7 & 0xFF;
            double d6 = -0.5 * d2 + 1.5 * d3 + -1.5 * d4 + 0.5 * d5;
            double d7 = d2 + -2.5 * d3 + 2.0 * d4 + -0.5 * d5;
            double d8 = -0.5 * d2 + 0.0 * d3 + 0.5 * d4 + 0.0 * d5;
            double d9 = 0.0 * d2 + d3 + 0.0 * d4 + 0.0 * d5;
            int n8 = (int)(((d6 * d + d7) * d + d8) * d + d9);
            if (n8 < 0) {
                n8 = 0;
            } else if (n8 > 255) {
                n8 = 255;
            }
            n5 |= n8 << n7;
            ++n6;
        }
        return n5;
    }

    /*
     * Unable to fully structure code
     */
    public static void resample(int[] var0, int[] var1_1, int var2_2, int var3_3, int var4_4, float[] var5_5) {
        var6_6 = var3_3;
        var7_7 = var3_3;
        var8_8 = var0.length;
        var9_9 = new double[var2_2 + 1];
        var10_10 = 0;
        var11_11 = 0;
        ** GOTO lbl13
        {
            ++var10_10;
            do {
                if (var5_5[var10_10 + 1] < (float)var11_11) continue block0;
                var9_9[var11_11] = (double)var10_10 + (double)((float)var11_11 - var5_5[var10_10]) / (double)(var5_5[var10_10 + 1] - var5_5[var10_10]);
                ++var11_11;
lbl13:
                // 2 sources

            } while (var11_11 < var2_2);
        }
        var9_9[var2_2] = var2_2;
        var12_12 = 1.0;
        var16_14 = var14_13 = var9_9[1];
        var18_15 = 0.0;
        var20_16 = 0.0;
        var22_17 = 0.0;
        var24_18 = 0.0;
        var26_19 = var0[var6_6];
        var27_20 = var26_19 >> 24 & 255;
        var28_21 = var26_19 >> 16 & 255;
        var29_22 = var26_19 >> 8 & 255;
        var30_23 = var26_19 & 255;
        var26_19 = var0[var6_6 += var4_4];
        var31_24 = var26_19 >> 24 & 255;
        var32_25 = var26_19 >> 16 & 255;
        var33_26 = var26_19 >> 8 & 255;
        var34_27 = var26_19 & 255;
        var6_6 += var4_4;
        var10_10 = 1;
        while (var10_10 < var2_2) {
            var35_28 = var12_12 * (double)var27_20 + (1.0 - var12_12) * (double)var31_24;
            var37_29 = var12_12 * (double)var28_21 + (1.0 - var12_12) * (double)var32_25;
            var39_30 = var12_12 * (double)var29_22 + (1.0 - var12_12) * (double)var33_26;
            var41_31 = var12_12 * (double)var30_23 + (1.0 - var12_12) * (double)var34_27;
            if (var12_12 < var14_13) {
                var24_18 += var35_28 * var12_12;
                var22_17 += var37_29 * var12_12;
                var20_16 += var39_30 * var12_12;
                var18_15 += var41_31 * var12_12;
                var14_13 -= var12_12;
                var12_12 = 1.0;
                var27_20 = var31_24;
                var28_21 = var32_25;
                var29_22 = var33_26;
                var30_23 = var34_27;
                if (var6_6 < var8_8) {
                    var26_19 = var0[var6_6];
                }
                var31_24 = var26_19 >> 24 & 255;
                var32_25 = var26_19 >> 16 & 255;
                var33_26 = var26_19 >> 8 & 255;
                var34_27 = var26_19 & 255;
                var6_6 += var4_4;
                continue;
            }
            var1_1[var7_7] = (int)Math.min((var24_18 += var35_28 * var14_13) / var16_14, 255.0) << 24 | (int)Math.min((var22_17 += var37_29 * var14_13) / var16_14, 255.0) << 16 | (int)Math.min((var20_16 += var39_30 * var14_13) / var16_14, 255.0) << 8 | (int)Math.min((var18_15 += var41_31 * var14_13) / var16_14, 255.0);
            var7_7 += var4_4;
            var18_15 = 0.0;
            var20_16 = 0.0;
            var22_17 = 0.0;
            var12_12 -= var14_13;
            var16_14 = var14_13 = var9_9[var10_10 + 1] - var9_9[var10_10];
            ++var10_10;
        }
    }
}

