/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.com.jhlabs.image;

import java.awt.Color;
import java.io.Serializable;
import jj.play.ns.com.jhlabs.image.ArrayColormap;
import jj.play.ns.com.jhlabs.image.ImageMath;
import jj.play.ns.com.jhlabs.image.PixelUtils;

public class Gradient
extends ArrayColormap
implements Cloneable,
Serializable {
    static final long serialVersionUID = 1479681703781917357L;
    public static final int RGB = 0;
    public static final int HUE_CW = 1;
    public static final int HUE_CCW = 2;
    public static final int LINEAR = 16;
    public static final int SPLINE = 32;
    public static final int CIRCLE_UP = 48;
    public static final int CIRCLE_DOWN = 64;
    public static final int CONSTANT = 80;
    private static final int COLOR_MASK = 3;
    private static final int BLEND_MASK = 112;
    public int numKnots = 4;
    public int[] xKnots;
    public int[] yKnots;
    public byte[] knotTypes;

    public Gradient() {
        int[] nArray = new int[4];
        nArray[2] = 255;
        nArray[3] = 255;
        this.xKnots = nArray;
        this.yKnots = new int[]{-16777216, -16777216, -1, -1};
        this.knotTypes = new byte[]{32, 32, 32, 32};
        this.rebuildGradient();
    }

    public Object clone() {
        Gradient gradient = (Gradient)super.clone();
        gradient.map = (int[])this.map.clone();
        gradient.xKnots = (int[])this.xKnots.clone();
        gradient.yKnots = (int[])this.yKnots.clone();
        gradient.knotTypes = (byte[])this.knotTypes.clone();
        return gradient;
    }

    public void copyTo(Gradient gradient) {
        gradient.numKnots = this.numKnots;
        gradient.map = (int[])this.map.clone();
        gradient.xKnots = (int[])this.xKnots.clone();
        gradient.yKnots = (int[])this.yKnots.clone();
        gradient.knotTypes = (byte[])this.knotTypes.clone();
    }

    public void setColor(int n, int n2) {
        int n3;
        int n4 = this.map[0];
        int n5 = this.map[255];
        if (n > 0) {
            n3 = 0;
            while (n3 < n) {
                this.map[n3] = ImageMath.mixColors((double)n3 / (double)n, n4, n2);
                ++n3;
            }
        }
        if (n < 255) {
            n3 = n;
            while (n3 < 256) {
                this.map[n3] = ImageMath.mixColors((double)(n3 - n) / (double)(256 - n), n2, n5);
                ++n3;
            }
        }
    }

    public int getKnot(int n) {
        return this.yKnots[n];
    }

    public void setKnot(int n, int n2) {
        this.yKnots[n] = n2;
        this.rebuildGradient();
    }

    public void setKnotType(int n, int n2) {
        this.knotTypes[n] = (byte)(this.knotTypes[n] & 0xFFFFFFFC | n2);
        this.rebuildGradient();
    }

    public int getKnotType(int n) {
        return (byte)(this.knotTypes[n] & 3);
    }

    public void setKnotBlend(int n, int n2) {
        this.knotTypes[n] = (byte)(this.knotTypes[n] & 0xFFFFFF8F | n2);
        this.rebuildGradient();
    }

    public byte getKnotBlend(int n) {
        return (byte)(this.knotTypes[n] & 0x70);
    }

    public void addKnot(int n, int n2, int n3) {
        int[] nArray = new int[this.numKnots + 1];
        int[] nArray2 = new int[this.numKnots + 1];
        byte[] byArray = new byte[this.numKnots + 1];
        System.arraycopy(this.xKnots, 0, nArray, 0, this.numKnots);
        System.arraycopy(this.yKnots, 0, nArray2, 0, this.numKnots);
        System.arraycopy(this.knotTypes, 0, byArray, 0, this.numKnots);
        this.xKnots = nArray;
        this.yKnots = nArray2;
        this.knotTypes = byArray;
        this.xKnots[this.numKnots] = n;
        this.yKnots[this.numKnots] = n2;
        this.knotTypes[this.numKnots] = (byte)n3;
        ++this.numKnots;
        this.sortKnots();
        this.rebuildGradient();
    }

    public void removeKnot(int n) {
        if (this.numKnots <= 4) {
            return;
        }
        if (n < this.numKnots - 1) {
            System.arraycopy(this.xKnots, n + 1, this.xKnots, n, this.numKnots - n - 1);
            System.arraycopy(this.yKnots, n + 1, this.yKnots, n, this.numKnots - n - 1);
            System.arraycopy(this.knotTypes, n + 1, this.knotTypes, n, this.numKnots - n - 1);
        }
        --this.numKnots;
        if (this.xKnots[1] > 0) {
            this.xKnots[1] = 0;
        }
        this.rebuildGradient();
    }

    public void splitSpan(int n) {
        int n2 = (this.xKnots[n] + this.xKnots[n + 1]) / 2;
        this.addKnot(n2, this.getColor((double)n2 / 256.0), this.knotTypes[n]);
        this.rebuildGradient();
    }

    public void setKnotPosition(int n, int n2) {
        this.xKnots[n] = PixelUtils.clamp(n2);
        this.sortKnots();
        this.rebuildGradient();
    }

    public int knotAt(int n) {
        int n2 = 1;
        while (n2 < this.numKnots - 1) {
            if (this.xKnots[n2 + 1] > n) {
                return n2;
            }
            ++n2;
        }
        return 1;
    }

    private void rebuildGradient() {
        this.xKnots[0] = -1;
        this.xKnots[this.numKnots - 1] = 256;
        this.yKnots[0] = this.yKnots[1];
        this.yKnots[this.numKnots - 1] = this.yKnots[this.numKnots - 2];
        boolean bl = false;
        int n = 1;
        while (n < this.numKnots - 1) {
            double d = this.xKnots[n + 1] - this.xKnots[n];
            int n2 = this.xKnots[n + 1];
            if (n == this.numKnots - 2) {
                ++n2;
            }
            int n3 = this.xKnots[n];
            while (n3 < n2) {
                int n4 = this.yKnots[n];
                int n5 = this.yKnots[n + 1];
                float[] fArray = Color.RGBtoHSB(n4 >> 16 & 0xFF, n4 >> 8 & 0xFF, n4 & 0xFF, null);
                float[] fArray2 = Color.RGBtoHSB(n5 >> 16 & 0xFF, n5 >> 8 & 0xFF, n5 & 0xFF, null);
                double d2 = (double)(n3 - this.xKnots[n]) / d;
                int n6 = this.getKnotType(n);
                byte by = this.getKnotBlend(n);
                if (n3 >= 0 && n3 <= 255) {
                    switch (by) {
                        case 80: {
                            d2 = 0.0;
                            break;
                        }
                        case 32: {
                            d2 = ImageMath.smoothStep(0.15, 0.85, d2);
                            break;
                        }
                        case 48: {
                            d2 -= 1.0;
                            d2 = Math.sqrt(1.0 - d2 * d2);
                            break;
                        }
                        case 64: {
                            d2 = 1.0 - Math.sqrt(1.0 - d2 * d2);
                            break;
                        }
                    }
                    switch (n6) {
                        case 0: {
                            this.map[n3] = ImageMath.mixColors(d2, n4, n5);
                            break;
                        }
                        case 1: 
                        case 2: {
                            if (n6 == 1) {
                                if (fArray2[0] <= fArray[0]) {
                                    fArray2[0] = (float)((double)fArray2[0] + 1.0);
                                }
                            } else if (fArray[0] <= fArray2[1]) {
                                fArray[0] = (float)((double)fArray[0] + 1.0);
                            }
                            double d3 = ImageMath.lerp(d2, fArray[0], fArray2[0]) % (Math.PI * 2);
                            double d4 = ImageMath.lerp(d2, fArray[1], fArray2[1]);
                            double d5 = ImageMath.lerp(d2, fArray[2], fArray2[2]);
                            this.map[n3] = 0xFF000000 | Color.HSBtoRGB((float)d3, (float)d4, (float)d5);
                            break;
                        }
                    }
                }
                ++n3;
            }
            ++n;
        }
    }

    private void sortKnots() {
        int n = 1;
        while (n < this.numKnots) {
            int n2 = 1;
            while (n2 < n) {
                if (this.xKnots[n] < this.xKnots[n2]) {
                    int n3 = this.xKnots[n];
                    this.xKnots[n] = this.xKnots[n2];
                    this.xKnots[n2] = n3;
                    n3 = this.yKnots[n];
                    this.yKnots[n] = this.yKnots[n2];
                    this.yKnots[n2] = n3;
                    byte by = this.knotTypes[n];
                    this.knotTypes[n] = this.knotTypes[n2];
                    this.knotTypes[n2] = by;
                }
                ++n2;
            }
            ++n;
        }
    }

    public void randomize() {
        this.numKnots = 4 + (int)(6.0 * Math.random());
        this.xKnots = new int[this.numKnots];
        this.yKnots = new int[this.numKnots];
        this.knotTypes = new byte[this.numKnots];
        int n = 0;
        while (n < this.numKnots) {
            this.xKnots[n] = (int)(255.0 * Math.random());
            this.yKnots[n] = 0xFF000000 | (int)(255.0 * Math.random()) << 16 | (int)(255.0 * Math.random()) << 8 | (int)(255.0 * Math.random());
            this.knotTypes[n] = 32;
            ++n;
        }
        this.xKnots[0] = -1;
        this.xKnots[1] = 0;
        this.xKnots[this.numKnots - 2] = 255;
        this.xKnots[this.numKnots - 1] = 256;
        this.sortKnots();
        this.rebuildGradient();
    }

    public static Gradient randomGradient() {
        Gradient gradient = new Gradient();
        gradient.randomize();
        return gradient;
    }
}

