/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.com.jhlabs.image;

import jj.play.ns.com.jhlabs.image.TransferFilter;

public class GammaFilter
extends TransferFilter {
    static final long serialVersionUID = -5329733893740770899L;
    private double rGamma;
    private double gGamma;
    private double bGamma;

    public GammaFilter() {
        this(1.0);
    }

    public GammaFilter(double d) {
        this(d, d, d);
    }

    public GammaFilter(double d, double d2, double d3) {
        this.setGamma(d, d2, d3);
    }

    public void setGamma(double d, double d2, double d3) {
        this.rGamma = d;
        this.gGamma = d2;
        this.bGamma = d3;
        this.initialized = false;
    }

    public void setGamma(double d) {
        this.setGamma(d, d, d);
    }

    public double getGamma() {
        return this.rGamma;
    }

    protected void initialize() {
        this.rTable = this.makeTable(this.rGamma);
        this.gTable = this.gGamma == this.rGamma ? this.rTable : this.makeTable(this.gGamma);
        this.bTable = this.bGamma == this.rGamma ? this.rTable : (this.bGamma == this.gGamma ? this.gTable : this.makeTable(this.bGamma));
    }

    protected int[] makeTable(double d) {
        int[] nArray = new int[256];
        int n = 0;
        while (n < 256) {
            nArray[n] = this.transferFunction(n);
            int n2 = (int)(255.0 * Math.pow((double)n / 255.0, 1.0 / d) + 0.5);
            if (n2 > 255) {
                n2 = 255;
            }
            nArray[n] = n2;
            ++n;
        }
        return nArray;
    }

    public String toString() {
        return "Colors/Gamma...";
    }
}

