/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.com.jhlabs.image;

import java.io.Serializable;
import jj.play.ns.com.jhlabs.image.PixelUtils;
import jj.play.ns.com.jhlabs.image.WholeImageFilter;

public class EmbossFilter
extends WholeImageFilter
implements Serializable {
    static final long serialVersionUID = 1923710925649589104L;
    private static final double pixelScale = 255.9;
    private double azimuth = 2.356194490192345;
    private double elevation = 0.5235987755982988;
    private boolean emboss = false;
    private double width45 = 3.0;

    public void setAzimuth(double d) {
        this.azimuth = d;
    }

    public double getAzimuth() {
        return this.azimuth;
    }

    public void setElevation(double d) {
        this.elevation = d;
    }

    public double getElevation() {
        return this.elevation;
    }

    public void setBumpHeight(double d) {
        this.width45 = 3.0 * d;
    }

    public double getBumpHeight() {
        return this.width45 / 3.0;
    }

    public void setEmboss(boolean bl) {
        this.emboss = bl;
    }

    public boolean getEmboss() {
        return this.emboss;
    }

    public void imageComplete(int n) {
        if (n == 1 || n == 4) {
            this.consumer.imageComplete(n);
            return;
        }
        int n2 = this.transformedSpace.width;
        int n3 = this.transformedSpace.height;
        int n4 = 0;
        int[] nArray = new int[n2 * n3];
        int n5 = n2;
        int n6 = n3;
        int[] nArray2 = new int[n5 * n6];
        int n7 = 0;
        while (n7 < this.inPixels.length) {
            nArray2[n7] = PixelUtils.brightness(this.inPixels[n7]);
            ++n7;
        }
        int n8 = (int)(Math.cos(this.azimuth) * Math.cos(this.elevation) * 255.9);
        int n9 = (int)(Math.sin(this.azimuth) * Math.cos(this.elevation) * 255.9);
        int n10 = (int)(Math.sin(this.elevation) * 255.9);
        int n11 = (int)(1530.0 / this.width45);
        int n12 = n11 * n11;
        int n13 = n11 * n10;
        int n14 = n10;
        int n15 = 0;
        int n16 = 0;
        while (n16 < n3) {
            int n17 = n15;
            int n18 = n17 + n5;
            int n19 = n18 + n5;
            int n20 = 0;
            while (n20 < n2) {
                int n21;
                if (n16 != 0 && n16 < n3 - 2 && n20 != 0 && n20 < n2 - 2) {
                    int n22;
                    int n23 = nArray2[n17 - 1] + nArray2[n18 - 1] + nArray2[n19 - 1] - nArray2[n17 + 1] - nArray2[n18 + 1] - nArray2[n19 + 1];
                    int n24 = nArray2[n19 - 1] + nArray2[n19] + nArray2[n19 + 1] - nArray2[n17 - 1] - nArray2[n17] - nArray2[n17 + 1];
                    n21 = n23 == 0 && n24 == 0 ? n14 : ((n22 = n23 * n8 + n24 * n9 + n13) < 0 ? 0 : (int)((double)n22 / Math.sqrt(n23 * n23 + n24 * n24 + n12)));
                } else {
                    n21 = n14;
                }
                if (this.emboss) {
                    int n25 = this.inPixels[n4];
                    int n26 = n25 & 0xFF000000;
                    int n27 = n25 >> 16 & 0xFF;
                    int n28 = n25 >> 8 & 0xFF;
                    int n29 = n25 & 0xFF;
                    n27 = n27 * n21 >> 8;
                    n28 = n28 * n21 >> 8;
                    n29 = n29 * n21 >> 8;
                    nArray[n4++] = n26 | n27 << 16 | n28 << 8 | n29;
                } else {
                    nArray[n4++] = 0xFF000000 | n21 << 16 | n21 << 8 | n21;
                }
                ++n20;
                ++n17;
                ++n18;
                ++n19;
            }
            ++n16;
            n15 += n5;
        }
        this.consumer.setPixels(0, 0, n2, n3, this.defaultRGBModel, nArray, 0, n2);
        this.consumer.imageComplete(n);
        this.inPixels = null;
    }

    public String toString() {
        return "Stylize/Emboss...";
    }
}

