/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.com.jhlabs.image;

import jj.play.ns.com.jhlabs.image.PixelUtils;
import jj.play.ns.com.jhlabs.image.WholeImageFilter;

public class DiffusionFilter
extends WholeImageFilter {
    static final long serialVersionUID = -451794416265414755L;
    protected static final int[] diffusionMatrix;
    private int[] matrix;
    private int sum = 16;
    private boolean serpentine = true;
    private boolean colorDither = true;
    public int levels = 6;

    static {
        int[] nArray = new int[9];
        nArray[5] = 7;
        nArray[6] = 3;
        nArray[7] = 5;
        nArray[8] = 1;
        diffusionMatrix = nArray;
    }

    public DiffusionFilter() {
        this.setMatrix(diffusionMatrix);
    }

    public void setSerpentine(boolean bl) {
        this.serpentine = bl;
    }

    public boolean getSerpentine() {
        return this.serpentine;
    }

    public void setColorDither(boolean bl) {
        this.colorDither = bl;
    }

    public boolean getColorDither() {
        return this.colorDither;
    }

    public void setMatrix(int[] nArray) {
        this.matrix = nArray;
        this.sum = 0;
        int n = 0;
        while (n < nArray.length) {
            this.sum += nArray[n];
            ++n;
        }
    }

    public int[] getMatrix() {
        return this.matrix;
    }

    public void setLevels(int n) {
        this.levels = n;
    }

    public int getLevels() {
        return this.levels;
    }

    public void imageComplete(int n) {
        if (n == 1 || n == 4) {
            this.consumer.imageComplete(n);
            return;
        }
        int n2 = this.originalSpace.width;
        int n3 = this.originalSpace.height;
        int[] nArray = new int[n2 * n3];
        int n4 = 0;
        int[] nArray2 = new int[this.levels];
        int n5 = 0;
        while (n5 < this.levels) {
            int n6;
            nArray2[n5] = n6 = 255 * n5 / (this.levels - 1);
            ++n5;
        }
        int[] nArray3 = new int[256];
        int n7 = 0;
        while (n7 < 256) {
            nArray3[n7] = this.levels * n7 / 256;
            ++n7;
        }
        int n8 = 0;
        while (n8 < n3) {
            int n9;
            boolean bl;
            boolean bl2 = bl = this.serpentine && (n8 & 1) == 1;
            if (bl) {
                n4 = n8 * n2 + n2 - 1;
                n9 = -1;
            } else {
                n4 = n8 * n2;
                n9 = 1;
            }
            int n10 = 0;
            while (n10 < n2) {
                int n11 = this.inPixels[n4];
                int n12 = n11 >> 16 & 0xFF;
                int n13 = n11 >> 8 & 0xFF;
                int n14 = n11 & 0xFF;
                if (!this.colorDither) {
                    n13 = n14 = (n12 + n13 + n14) / 3;
                    n12 = n14;
                }
                int n15 = nArray2[nArray3[n12]];
                int n16 = nArray2[nArray3[n13]];
                int n17 = nArray2[nArray3[n14]];
                nArray[n4] = 0xFF000000 | n15 << 16 | n16 << 8 | n17;
                int n18 = n12 - n15;
                int n19 = n13 - n16;
                int n20 = n14 - n17;
                int n21 = -1;
                while (n21 <= 1) {
                    int n22 = n21 + n8;
                    if (n22 >= 0 && n22 < n3) {
                        int n23 = -1;
                        while (n23 <= 1) {
                            int n24;
                            int n25 = n23 + n10;
                            if (n25 >= 0 && n25 < n2 && (n24 = bl ? this.matrix[(n21 + 1) * 3 - n23 + 1] : this.matrix[(n21 + 1) * 3 + n23 + 1]) != 0) {
                                int n26 = bl ? n4 - n23 : n4 + n23;
                                n11 = this.inPixels[n26];
                                n12 = n11 >> 16 & 0xFF;
                                n13 = n11 >> 8 & 0xFF;
                                n14 = n11 & 0xFF;
                                this.inPixels[n26] = PixelUtils.clamp(n12 += n18 * n24 / this.sum) << 16 | PixelUtils.clamp(n13 += n19 * n24 / this.sum) << 8 | PixelUtils.clamp(n14 += n20 * n24 / this.sum);
                            }
                            ++n23;
                        }
                    }
                    ++n21;
                }
                n4 += n9;
                ++n10;
            }
            ++n8;
        }
        this.consumer.setPixels(0, 0, n2, n3, this.defaultRGBModel, nArray, 0, n2);
        this.consumer.imageComplete(n);
        this.inPixels = null;
    }

    public String toString() {
        return "Colors/Diffusion Dither...";
    }
}

