/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.com.jhlabs.image;

import java.awt.image.RGBImageFilter;
import jj.play.ns.com.jhlabs.image.ImageMath;
import jj.play.ns.com.jhlabs.math.Noise;

public class BrickFilter
extends RGBImageFilter {
    private int xScale = 30;
    private int yScale = 40;
    private int foreground = -7859951;
    private int background = -7829368;
    private int fuzziness = 0;
    private double randomness = 0.0;
    private double mortarWidth = 0.06;
    private double angle = 0.0;
    private int operation;
    private double m00 = 1.0;
    private double m01 = 0.0;
    private double m10 = 0.0;
    private double m11 = 1.0;
    public static final double BRICKWIDTH = 1.0;
    public static final double BRICKHEIGHT = 0.25;

    public void setForeground(int n) {
        this.foreground = n;
    }

    public int getForeground() {
        return this.foreground;
    }

    public void setBackground(int n) {
        this.background = n;
    }

    public int getBackground() {
        return this.background;
    }

    public void setXScale(int n) {
        this.xScale = n;
    }

    public int getXScale() {
        return this.xScale;
    }

    public void setYScale(int n) {
        this.yScale = n;
    }

    public int getYScale() {
        return this.yScale;
    }

    public void setFuzziness(int n) {
        this.fuzziness = n;
    }

    public int getFuzziness() {
        return this.fuzziness;
    }

    public void setOperation(int n) {
        this.operation = n;
    }

    public int getOperation() {
        return this.operation;
    }

    public void setMortarWidth(double d) {
        this.mortarWidth = d;
    }

    public double getMortarWidth() {
        return this.mortarWidth;
    }

    public void setRandomness(double d) {
        this.randomness = d;
    }

    public double getRandomness() {
        return this.randomness;
    }

    public void setAngle(double d) {
        this.angle = d;
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        this.m00 = d2;
        this.m01 = d3;
        this.m10 = -d3;
        this.m11 = d2;
    }

    public double getAngle() {
        return this.angle;
    }

    public static double boxstep(double d, double d2, double d3) {
        return ImageMath.clamp((d3 - d) / (d2 - d), 0.0, 1.0);
    }

    public int filterRGB(int n, int n2, int n3) {
        double d = (this.m00 * (double)n + this.m01 * (double)n2) / (double)this.xScale;
        double d2 = (this.m10 * (double)n + this.m11 * (double)n2) / (double)this.yScale;
        double d3 = 1.0 + this.mortarWidth;
        double d4 = 0.25 + this.mortarWidth;
        double d5 = this.mortarWidth * 0.5 / d3;
        double d6 = this.mortarWidth * 0.5 / d4;
        double d7 = d / d3;
        double d8 = d2 / d4;
        if (ImageMath.mod(d8 * 0.5, 1.0) > 0.5) {
            d7 += 0.5;
        }
        double d9 = 1.5 / (double)this.xScale;
        double d10 = 1.5 / (double)this.yScale;
        double d11 = Math.floor(d7);
        double d12 = Math.floor(d8);
        if (this.randomness != 0.0) {
            d11 = Math.floor(d7 += 0.1 * this.randomness * Noise.noise1(d12 + 0.5));
            d12 = Math.floor(d8 += 0.1 * this.randomness * Noise.noise1(d11 + 0.5));
        }
        double d13 = BrickFilter.boxstep(d5 - d9, d5, d7 -= d11) - BrickFilter.boxstep(1.0 - d5 - d9, 1.0 - d5, d7);
        double d14 = BrickFilter.boxstep(d6 - d10, d6, d8 -= d12) - BrickFilter.boxstep(1.0 - d6 - d10, 1.0 - d6, d8);
        double d15 = d13 * d14;
        if (this.randomness != 0.0) {
            d15 += 0.1 * this.randomness * Noise.noise2(d11 + 0.5, d12 + 0.5);
        }
        return ImageMath.mixColors(d15, this.background, this.foreground);
    }

    public String toString() {
        return "Texture/Brick...";
    }
}

