/*
 * Decompiled with CFR 0.152.
 */
package org.playframework.playclipse.editors;

import fr.zenexity.pdt.editors.Editor;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IFileEditorInput;
import org.playframework.playclipse.Navigation;

public abstract class PlayEditor
extends Editor {
    private Navigation navigation;

    protected Navigation getNav() {
        if (this.navigation == null) {
            this.navigation = new Navigation(this.getHelper());
        }
        return this.navigation;
    }

    @Override
    public void openLink(IHyperlink link) {
        String linkText = link.getHyperlinkText();
        if (link.getTypeLabel().equals("action")) {
            if (linkText.startsWith("'") && linkText.endsWith("'")) {
                String path = linkText.substring(1, linkText.length() - 1);
                this.getNav().openOrCreate(path);
                return;
            }
            String nakedAction = linkText.replaceFirst("\\(.*\\)", "");
            if (nakedAction.indexOf(46) == -1) {
                IFile curfile = ((IFileEditorInput)this.getEditorInput()).getFile();
                String controller = curfile.getParent().getName();
                nakedAction = String.valueOf(controller) + "." + nakedAction;
            }
            this.getNav().goToAction(nakedAction);
            return;
        }
        if (link.getTypeLabel().equals("tag")) {
            this.getNav().goToView("tags/" + link.getHyperlinkText().replace('.', '/') + ".html");
            return;
        }
        if (link.getTypeLabel().equals("extends") || link.getTypeLabel().equals("include")) {
            String path = link.getHyperlinkText();
            this.getNav().goToView(path);
        }
        if (link.getTypeLabel().equals("action_in_tag")) {
            System.out.println(linkText);
            String nakedAction = linkText.replace("@", "").replaceFirst("\\(.*\\)", "");
            this.getNav().goToAction(nakedAction);
        }
    }
}

