package play.data.validation;

import java.util.Collection;
import java.util.List;
import net.sf.oval.ConstraintViolation;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.context.FieldContext;
import net.sf.oval.context.MethodParameterContext;
import net.sf.oval.context.OValContext;
import play.exceptions.UnexpectedException;
import play.utils.Java;

@SuppressWarnings("serial")
public class ValidCheck extends AbstractAnnotationCheck<Required> {

    final static String mes = "validation.object";
    String key;

    public boolean isSatisfied(Object validatedObject, Object value, OValContext context, Validator validator) {
        String superKey = ValidationPlugin.keys.get().get(validatedObject);
        if (value == null) {
            return true;
        }
        try {
            if (context != null) {
                if (context instanceof MethodParameterContext) {
                    MethodParameterContext ctx = (MethodParameterContext) context;
                    String[] paramNames = Java.parameterNames(ctx.getMethod());
                    key = paramNames[ctx.getParameterIndex()];
                }
                if (context instanceof FieldContext) {
                    FieldContext ctx = (FieldContext) context;
                    key = ctx.getField().getName();
                }
            }
        } catch (Exception e) {
            throw new UnexpectedException(e);
        }
        if (superKey != null) {
            key = superKey + "." + key;
        }
        if(value instanceof Collection) {
            Collection valueCollection = (Collection)value;
            boolean everythingIsValid = true;
            int index = 0;
            for(Object item : valueCollection) {
                if(!validateObject(key + "[" + (index) + "]", item)) {
                    Validation.current().errors.add(new Error(key + "[" + (index) + "]", mes, new String[0]));
                    everythingIsValid = false;
                }
                index++;
            }
            if(!everythingIsValid) {
                return false;
            } else {
                return true;
            }
        } else {
            return validateObject(key, value);
        }
    }

    boolean validateObject(String key, Object value) {
        ValidationPlugin.keys.get().put(value, key);
        List<ConstraintViolation> violations = new Validator().validate(value);
        //
        if (violations.isEmpty()) {
            return true;
        } else {
            for (ConstraintViolation violation : violations) {
                if (violation.getContext() instanceof FieldContext) {
                    final FieldContext ctx = (FieldContext) violation.getContext();
                    final String fkey = (key == null ? "" : key + ".") + ctx.getField().getName();
                    final Error error = new Error(fkey, violation.getMessage(), violation.getMessageVariables() == null ? new String[0] : violation.getMessageVariables().values().toArray(new String[0]));
                    Validation.current().errors.add(error);
                }
            }
            return false;
        }
    }
    
}
