/*
 * Decompiled with CFR 0.152.
 */
package org.playframework.playclipse.editors.html;

import fr.zenexity.pdt.editors.Editor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.playframework.playclipse.PlayPlugin;
import org.playframework.playclipse.editors.PlayEditor;
import org.playframework.playclipse.editors.html.HTMLConfiguration;

public class HTMLEditor
extends PlayEditor {
    public static final String DEFAULT_COLOR = "html_default_color";
    public static final String DOCTYPE_COLOR = "html_doctype_color";
    public static final String HTML_COLOR = "html_html_color";
    public static final String TAG_COLOR = "html_tag_color";
    public static final String EXPR_COLOR = "html_expr_color";
    public static final String ACTION_COLOR = "html_action_color";
    public static final String SKIPPED_COLOR = "html_skipped_color";
    public static final String KEYWORD_COLOR = "html_keyword_color";
    public static final String STRING_COLOR = "html_string_color";
    public static final String SOFT_TABS = "html_soft_tabs";
    public static final String SOFT_TABS_WIDTH = "html_soft_tabs_width";
    public static final String MISSING_ACTION = "html_missing_action";
    private ProjectionSupport projectionSupport;
    Pattern extend_s = Pattern.compile("#\\{extends\\s+'([^']+)'");
    Pattern include = Pattern.compile("#\\{include\\s+'([^']+)'");
    Pattern action = Pattern.compile("@\\{([^}]+)\\}");
    Pattern action_in_tag = Pattern.compile("#\\{.+(@.+[)])");
    Pattern tag = Pattern.compile("#\\{([-a-zA-Z0-9.]+) ");
    boolean consumeString = false;
    char openedString = (char)32;
    String oldState = "default";
    String oldStringState = "default";
    private Annotation[] oldAnnotations;
    private ProjectionAnnotationModel annotationModel;

    public HTMLEditor() {
        this.setSourceViewerConfiguration(new HTMLConfiguration(this));
        IPreferenceStore store = PlayPlugin.getDefault().getPreferenceStore();
        this.useSoftTabs = store.getBoolean(SOFT_TABS);
        this.softTabsWidth = store.getInt(SOFT_TABS_WIDTH);
    }

    @Override
    public String[] getTypes() {
        return new String[]{"default", "doctype", "html", "string", "tag", "expression", "action", "skipped", "keyword"};
    }

    @Override
    public String getStylePref(String type) {
        if (type.equals("doctype")) {
            return DOCTYPE_COLOR;
        }
        if (type.equals("html")) {
            return HTML_COLOR;
        }
        if (type.equals("string")) {
            return STRING_COLOR;
        }
        if (type.equals("tag")) {
            return TAG_COLOR;
        }
        if (type.equals("expression")) {
            return EXPR_COLOR;
        }
        if (type.equals("action")) {
            return ACTION_COLOR;
        }
        if (type.equals("skipped")) {
            return SKIPPED_COLOR;
        }
        if (type.equals("keyword")) {
            return KEYWORD_COLOR;
        }
        return DEFAULT_COLOR;
    }

    @Override
    public String autoClose(char pc, char c, char nc) {
        if (c == '<') {
            return ">";
        }
        if (c == '>' && nc == '>') {
            return SKIP;
        }
        if (c == '{') {
            return "}";
        }
        if (c == '}' && nc == '}') {
            return SKIP;
        }
        if (c == '(') {
            return ")";
        }
        if (c == ')' && nc == ')') {
            return SKIP;
        }
        if (c == '[') {
            return "]";
        }
        if (c == ']' && nc == ']') {
            return SKIP;
        }
        if (c == '\'') {
            if (nc == '\'') {
                return SKIP;
            }
            return "'";
        }
        if (c == '\"') {
            if (nc == '\"') {
                return SKIP;
            }
            return "\"";
        }
        return null;
    }

    @Override
    public void templates(String contentType, String ctx) {
        Matcher isTag;
        if (contentType == "default" || contentType == "html" || contentType == "string") {
            this.template("$", "Insert dynamic expression", "$${${}}${cursor}");
            this.template("tag", "Insert tag without body", "#{${name} ${}/}${cursor}");
            this.template("action", "Insert action", "@{${}}${cursor}");
            this.template("tag", "Insert tag with body", "##{${name} ${}}${cursor}#{/${name}}");
        }
        if (contentType == "default") {
            this.template("if", "Insert a #if tag", "#{if ${}}\n    ${cursor}\n#{/if}");
            this.template("extends", "Insert a #extends tag", "#{extends '${}' /}${cursor}");
            this.template("list", "Insert a #list tag", "#{list ${}, as:'${i}'}\n    ${cursor}\n#{/list>");
            this.template("doctype", "Insert an HTML5 doctype element", "<!DOCTYPE html>");
        }
        if ((isTag = Pattern.compile("<([a-zA-Z]+)>").matcher(ctx)).matches()) {
            String closeTag = "</" + isTag.group(1) + ">";
            this.template(ctx, "Close the " + ctx + " HTML tag", "${cursor}" + closeTag);
        }
    }

    @Override
    public IHyperlink detectHyperlink(ITextViewer textViewer, IRegion region) {
        Editor.BestMatch match = this.findBestMatch(region.getOffset(), this.include, this.extend_s, this.action, this.action_in_tag, this.tag);
        if (match != null) {
            if (match.is(this.action)) {
                return match.hyperlink("action", 0, 0);
            }
            if (match.is(this.tag)) {
                return match.hyperlink("tag", 2, -1);
            }
            if (match.is(this.extend_s)) {
                return match.hyperlink("extends", match.matcher.start(1) - match.matcher.start(), -1);
            }
            if (match.is(this.include)) {
                return match.hyperlink("include", match.matcher.start(1) - match.matcher.start(), -1);
            }
            if (match.is(this.action_in_tag)) {
                return match.hyperlink("action_in_tag", match.matcher.start(1) - match.matcher.start(), 0);
            }
        }
        return null;
    }

    @Override
    protected void reset() {
        super.reset();
        this.consumeString = false;
        this.oldState = "default";
    }

    @Override
    public String scan() {
        if (this.isNext("*{") && this.state != "skipped") {
            this.oldState = this.state;
            return this.found("skipped", 0);
        }
        if (this.state == "skipped" && this.isNext("}*")) {
            return this.found(this.oldState, 2);
        }
        if (this.state == "default" || this.state == "html" || this.state == "string") {
            if (this.isNext("#{")) {
                this.oldState = this.state;
                return this.found("tag", 0);
            }
            if (this.isNext("${")) {
                this.oldState = this.state;
                return this.found("expression", 0);
            }
            if (this.isNext("@{") || this.isNext("@@{")) {
                this.oldState = this.state;
                return this.found("action", 0);
            }
        }
        if ((this.state == "tag" || this.state == "expression" || this.state == "action") && this.isNext("}")) {
            return this.found(this.oldState, 1);
        }
        if (this.state == "default") {
            if (this.isNext("<!DOCTYPE")) {
                return this.found("doctype", 0);
            }
            if (this.isNext("<")) {
                return this.found("html", 0);
            }
            if (this.isNext("var ")) {
                return this.found("keyword", 0);
            }
            if (this.isNext("def ")) {
                return this.found("keyword", 0);
            }
            if (this.isNext("return ")) {
                return this.found("keyword", 0);
            }
            if (this.isNext("function(")) {
                return this.found("keyword", 0);
            }
            if (this.isNext("function ")) {
                return this.found("keyword", 0);
            }
            if (this.isNext("if(")) {
                return this.found("keyword", 0);
            }
            if (this.isNext("if ")) {
                return this.found("keyword", 0);
            }
            if (this.isNext("else ")) {
                return this.found("keyword", 0);
            }
            if (this.isNext("switch(")) {
                return this.found("keyword", 0);
            }
            if (this.isNext("switch ")) {
                return this.found("keyword", 0);
            }
        }
        if (this.state == "keyword" && (this.isNext(" ") || this.isNext("("))) {
            return this.found("default", 0);
        }
        if ((this.state == "doctype" || this.state == "html") && this.isNext(">")) {
            return this.found("default", 1);
        }
        if (this.state == "html") {
            if (this.isNext("\"")) {
                this.openedString = (char)34;
                this.consumeString = false;
                this.oldStringState = this.state;
                return this.found("string", 0);
            }
            if (this.isNext("'")) {
                this.openedString = (char)39;
                this.consumeString = false;
                this.oldStringState = this.state;
                return this.found("string", 0);
            }
        }
        if (this.state == "string") {
            if (this.isNext("" + this.openedString) && this.consumeString) {
                return this.found(this.oldStringState, 1);
            }
            this.consumeString = true;
        }
        return null;
    }

    public void updateFoldingStructure(ArrayList<Position> positions) {
        Annotation[] annotations = new Annotation[positions.size()];
        HashMap<ProjectionAnnotation, Position> newAnnotations = new HashMap<ProjectionAnnotation, Position>();
        int i = 0;
        while (i < positions.size()) {
            ProjectionAnnotation annotation = new ProjectionAnnotation();
            newAnnotations.put(annotation, positions.get(i));
            annotations[i] = annotation;
            ++i;
        }
        this.annotationModel.modifyAnnotations(this.oldAnnotations, newAnnotations, null);
        this.oldAnnotations = annotations;
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.install();
        viewer.doOperation(19);
        this.annotationModel = viewer.getProjectionAnnotationModel();
    }

    @Override
    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        viewer.getTextWidget().addVerifyListener((VerifyListener)this);
        return viewer;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String key = event.getProperty();
        if (key.equals(SOFT_TABS)) {
            this.useSoftTabs = (Boolean)event.getNewValue();
        }
        super.propertyChange(event);
    }
}

