/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.internal.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.List;
import java.util.Locale;
import net.sf.oval.Validator;
import net.sf.oval.exception.AccessingFieldValueFailedException;
import net.sf.oval.exception.ConstraintsViolatedException;
import net.sf.oval.exception.InvokingMethodFailedException;
import net.sf.oval.internal.ContextCache;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.SetAccessibleAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtils {
    private static final Log LOG = Log.getLog(ReflectionUtils.class);

    public static Field getField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public static Field getFieldForSetter(Method setter) {
        if (!ReflectionUtils.isSetter(setter)) {
            return null;
        }
        Class<?>[] methodParameterTypes = setter.getParameterTypes();
        String methodName = setter.getName();
        Class<?> clazz = setter.getDeclaringClass();
        String fieldName = methodName.substring(3, 4).toLowerCase(Locale.getDefault());
        if (methodName.length() > 4) {
            fieldName = String.valueOf(fieldName) + methodName.substring(4);
        }
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
            if (!field.getType().equals(methodParameterTypes[0])) {
                LOG.warn("Found field <{1}> in class <{2}>that matches setter <{3}> name, but mismatches parameter type.", (Object)fieldName, (Object)clazz.getName(), methodName);
                field = null;
            }
        }
        catch (NoSuchFieldException e) {
            LOG.debug("Field not found", e);
        }
        if (field == null && (Boolean.TYPE.equals(methodParameterTypes[0]) || Boolean.class.equals(methodParameterTypes[0]))) {
            fieldName = "is" + methodName.substring(3);
            try {
                field = clazz.getDeclaredField(fieldName);
                if (!Boolean.TYPE.equals(field.getType()) && Boolean.class.equals(field.getType())) {
                    LOG.warn("Found field <{1}> in class <{2}>that matches setter <{3}> name, but mismatches parameter type.", (Object)fieldName, (Object)clazz.getName(), methodName);
                    field = null;
                }
            }
            catch (NoSuchFieldException ex) {
                LOG.debug("Field not found", ex);
            }
        }
        return field;
    }

    public static Field getFieldRecursive(Class<?> clazz, String fieldName) {
        Field f = ReflectionUtils.getField(clazz, fieldName);
        if (f != null) {
            return f;
        }
        Class<?> superclazz = clazz.getSuperclass();
        if (superclazz == null) {
            return null;
        }
        return ReflectionUtils.getFieldRecursive(superclazz, fieldName);
    }

    public static Object getFieldValue(Field field, Object obj) throws AccessingFieldValueFailedException {
        try {
            if (!field.isAccessible()) {
                AccessController.doPrivileged(new SetAccessibleAction(field));
            }
            return field.get(obj);
        }
        catch (Exception ex) {
            throw new AccessingFieldValueFailedException(field.getName(), obj, ContextCache.getFieldContext(field), ex);
        }
    }

    public static Method getGetter(Class<?> clazz, String propertyName) {
        String appendix = String.valueOf(propertyName.substring(0, 1).toUpperCase(Locale.getDefault())) + propertyName.substring(1);
        try {
            return clazz.getDeclaredMethod("get" + appendix, new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            LOG.trace("getXXX method not found.", ex);
            try {
                return clazz.getDeclaredMethod("is" + appendix, new Class[0]);
            }
            catch (NoSuchMethodException ex2) {
                LOG.trace("isXXX method not found.", ex2);
                return null;
            }
        }
    }

    public static Method getGetterRecursive(Class<?> clazz, String propertyName) {
        Method m = ReflectionUtils.getGetter(clazz, propertyName);
        if (m != null) {
            return m;
        }
        Class<?> superclazz = clazz.getSuperclass();
        if (superclazz == null) {
            return null;
        }
        return ReflectionUtils.getGetterRecursive(superclazz, propertyName);
    }

    public static List<Method> getInterfaceMethods(Method method) {
        if (ReflectionUtils.isStatic(method)) {
            return null;
        }
        Class<?>[] interfaces = method.getDeclaringClass().getInterfaces();
        if (interfaces.length == 0) {
            return null;
        }
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        List<Method> methods = Validator.getCollectionFactory().createList(interfaces.length);
        Class<?>[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iface = classArray[n2];
            Method m = ReflectionUtils.getMethod(iface, methodName, parameterTypes);
            if (m != null) {
                methods.add(m);
            }
            ++n2;
        }
        return methods;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getMethodRecursive(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Method m = ReflectionUtils.getMethod(clazz, methodName, parameterTypes);
        if (m != null) {
            return m;
        }
        Class<?> superclazz = clazz.getSuperclass();
        if (superclazz == null) {
            return null;
        }
        return ReflectionUtils.getMethodRecursive(superclazz, methodName, parameterTypes);
    }

    public static Method getSetter(Class<?> clazz, String propertyName) {
        Method[] declaredMethods;
        String methodName = "set" + propertyName.substring(0, 1).toUpperCase(Locale.getDefault()) + propertyName.substring(1);
        Method[] methodArray = declaredMethods = clazz.getDeclaredMethods();
        int n = declaredMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (methodName.equals(method.getName()) && method.getParameterTypes().length == 1) {
                return method;
            }
            ++n2;
        }
        LOG.trace("No setter for {} not found on class {}.", (Object)propertyName, clazz);
        return null;
    }

    public static Method getSetterRecursive(Class<?> clazz, String propertyName) {
        Method m = ReflectionUtils.getSetter(clazz, propertyName);
        if (m != null) {
            return m;
        }
        Class<?> superclazz = clazz.getSuperclass();
        if (superclazz == null) {
            return null;
        }
        return ReflectionUtils.getSetterRecursive(superclazz, propertyName);
    }

    public static Method getSuperMethod(Method method) {
        if (ReflectionUtils.isStatic(method)) {
            return null;
        }
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class<?> currentClass = method.getDeclaringClass();
        while (currentClass != null && currentClass != Object.class) {
            Method m = ReflectionUtils.getMethod(currentClass = currentClass.getSuperclass(), methodName, parameterTypes);
            if (m == null || ReflectionUtils.isPrivate(m)) continue;
            return m;
        }
        return null;
    }

    public static String guessFieldName(Method getter) {
        String fieldName = getter.getName();
        if (fieldName.startsWith("get") && fieldName.length() > 3) {
            fieldName = (fieldName = fieldName.substring(3)).length() == 1 ? fieldName.toLowerCase(Locale.getDefault()) : String.valueOf(Character.toLowerCase(fieldName.charAt(0))) + fieldName.substring(1);
        } else if (fieldName.startsWith("is") && fieldName.length() > 2) {
            fieldName = (fieldName = fieldName.substring(2)).length() == 1 ? fieldName.toLowerCase(Locale.getDefault()) : String.valueOf(Character.toLowerCase(fieldName.charAt(0))) + fieldName.substring(1);
        }
        return fieldName;
    }

    public static boolean hasField(Class<?> clazz, String fieldName) {
        return ReflectionUtils.getField(clazz, fieldName) != null;
    }

    public static boolean hasMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtils.getMethod(clazz, methodName, parameterTypes) != null;
    }

    public static Object invokeMethod(Method method, Object obj, Object ... args) throws InvokingMethodFailedException, ConstraintsViolatedException {
        try {
            if (!method.isAccessible()) {
                AccessController.doPrivileged(new SetAccessibleAction(method));
            }
            return method.invoke(obj, args);
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof ConstraintsViolatedException) {
                throw (ConstraintsViolatedException)ex.getCause();
            }
            throw new InvokingMethodFailedException("Executing method " + method.getName() + " failed.", obj, ContextCache.getMethodReturnValueContext(method), ex);
        }
    }

    public static boolean isClassPresent(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static boolean isFinal(Member member) {
        return (member.getModifiers() & 0x10) != 0;
    }

    public static boolean isGetter(Method method) {
        return method.getParameterTypes().length == 0 && (method.getName().startsWith("is") || method.getName().startsWith("get"));
    }

    public static boolean isNonStaticInnerClass(Class<?> clazz) {
        return clazz.getName().indexOf(36) > -1 && (clazz.getModifiers() & 8) == 0;
    }

    public static boolean isPackage(Member member) {
        return (member.getModifiers() & 7) == 0;
    }

    public static boolean isPrivate(Member member) {
        return (member.getModifiers() & 2) != 0;
    }

    public static boolean isProtected(Member member) {
        return (member.getModifiers() & 4) != 0;
    }

    public static boolean isSetter(Method method) {
        Class<?>[] methodParameterTypes = method.getParameterTypes();
        if (methodParameterTypes.length != 1) {
            return false;
        }
        String methodName = method.getName();
        int methodNameLen = methodName.length();
        return methodNameLen >= 4 && methodName.startsWith("set");
    }

    public static boolean isStatic(Member member) {
        return (member.getModifiers() & 8) != 0;
    }

    public static boolean isTransient(Member member) {
        return (member.getModifiers() & 0x80) != 0;
    }

    public static boolean isVoidMethod(Method method) {
        return method.getReturnType() == Void.TYPE;
    }

    public static boolean setViaSetter(Object target, String propertyName, Object propertyValue) {
        assert (target != null);
        assert (propertyName != null);
        Method setter = ReflectionUtils.getSetterRecursive(target.getClass(), propertyName);
        if (setter != null) {
            try {
                setter.invoke(target, propertyValue);
            }
            catch (IllegalArgumentException ex) {
                LOG.debug("Setting {1} failed on {2} failed.", (Object)propertyName, target, ex);
                return false;
            }
            catch (IllegalAccessException ex) {
                LOG.debug("Setting {1} failed on {2} failed.", (Object)propertyName, target, ex);
                return false;
            }
            catch (InvocationTargetException ex) {
                LOG.debug("Setting {1} failed on {2} failed.", (Object)propertyName, target, ex);
                return false;
            }
        }
        return false;
    }

    private ReflectionUtils() {
    }
}

