/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.nl.captcha.text.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.security.SecureRandom;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import jj.play.ns.nl.captcha.text.renderer.WordRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColoredEdgesWordRenderer
implements WordRenderer {
    private static final List<Color> DEFAULT_COLORS = new ArrayList<Color>();
    private static final List<Font> DEFAULT_FONTS = new ArrayList<Font>();
    private static final float DEFAULT_STROKE_WIDTH = 0.5f;
    private static final double YOFFSET = 0.25;
    private static final double XOFFSET = 0.05;
    private final List<Font> _fonts;
    private final List<Color> _colors;
    private final float _strokeWidth;

    public ColoredEdgesWordRenderer() {
        this(DEFAULT_COLORS, DEFAULT_FONTS, 0.5f);
    }

    public ColoredEdgesWordRenderer(List<Color> list, List<Font> list2) {
        this(list, list2, 0.5f);
    }

    public ColoredEdgesWordRenderer(List<Color> list, List<Font> list2, float f) {
        this._colors = list != null ? list : DEFAULT_COLORS;
        this._fonts = list2 != null ? list2 : DEFAULT_FONTS;
        this._strokeWidth = f < 0.0f ? 0.5f : f;
    }

    @Override
    public void render(String string, BufferedImage bufferedImage) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderingHints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        graphics2D.setRenderingHints(renderingHints);
        AttributedString attributedString = new AttributedString(string);
        attributedString.addAttribute(TextAttribute.FONT, this.getRandomFont());
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        TextLayout textLayout = new TextLayout(attributedCharacterIterator, fontRenderContext);
        int n = (int)Math.round((double)bufferedImage.getWidth() * 0.05);
        int n2 = bufferedImage.getHeight() - (int)Math.round((double)bufferedImage.getHeight() * 0.25);
        Shape shape = textLayout.getOutline(AffineTransform.getTranslateInstance(n, n2));
        graphics2D.setColor(this.getRandomColor());
        graphics2D.setStroke(new BasicStroke(this._strokeWidth));
        graphics2D.draw(shape);
    }

    private Color getRandomColor() {
        return (Color)this.getRandomObject(this._colors);
    }

    private Font getRandomFont() {
        return (Font)this.getRandomObject(this._fonts);
    }

    private Object getRandomObject(List<? extends Object> list) {
        if (list.size() == 1) {
            return list.get(0);
        }
        SecureRandom secureRandom = new SecureRandom();
        int n = secureRandom.nextInt(list.size());
        return list.get(n);
    }

    static {
        DEFAULT_FONTS.add(new Font("Arial", 1, 40));
        DEFAULT_COLORS.add(Color.BLUE);
    }
}

