/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.bytecode.transformation.asm;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import org.apache.commons.javaflow.bytecode.transformation.ResourceTransformer;
import org.apache.commons.javaflow.bytecode.transformation.asm.ContinuationClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.TraceClassVisitor;

public final class AsmClassTransformer
implements ResourceTransformer {
    private static final Field CHECK_DATA_FLOW;

    public byte[] transform(InputStream is) throws IOException {
        return this.transform(new ClassReader(is));
    }

    public byte[] transform(byte[] original) {
        return this.transform(new ClassReader(original));
    }

    private byte[] transform(ClassReader cr) {
        ClassWriter cw = new ClassWriter(1);
        cr.accept((ClassVisitor)new ContinuationClassAdapter(this.decorateClassVisitor((ClassVisitor)cw, true, null)), 0);
        byte[] bytecode = cw.toByteArray();
        return bytecode;
    }

    private ClassVisitor decorateClassVisitor(ClassVisitor visitor, boolean check, PrintStream dumpStream) {
        if (check) {
            visitor = new CheckClassAdapter(visitor);
            if (null != CHECK_DATA_FLOW) {
                try {
                    CHECK_DATA_FLOW.set(visitor, Boolean.FALSE);
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        if (null != dumpStream) {
            visitor = new TraceClassVisitor(visitor, new PrintWriter(dumpStream));
        }
        return visitor;
    }

    static {
        Field checkDataFlow = null;
        try {
            checkDataFlow = CheckClassAdapter.class.getDeclaredField("checkDataFlow");
            checkDataFlow.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        CHECK_DATA_FLOW = checkDataFlow;
    }
}

