/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.com.jhlabs.image;

import java.awt.image.RGBImageFilter;
import java.io.Serializable;
import jj.play.ns.com.jhlabs.image.ImageMath;
import jj.play.ns.com.jhlabs.math.Noise;

public class FlareFilter
extends RGBImageFilter
implements Serializable {
    static final long serialVersionUID = 1692413049411710802L;
    private int rays = 50;
    private int radius;
    private double baseAmount = 1.0;
    private double ringAmount = 0.2;
    private double rayAmount = 0.1;
    private int color = -1;
    private int width;
    private int height;
    private int centreX;
    private int centreY;
    private double ringWidth = 1.6;
    private double linear = 0.03;
    private double gauss = 0.006;
    private double mix = 0.5;
    private double falloff = 6.0;
    private double sigma;

    public FlareFilter() {
        this.setRadius(25);
    }

    public void setColor(int n) {
        this.color = n;
    }

    public int getColor() {
        return this.color;
    }

    public void setRingWidth(double d) {
        this.ringWidth = d;
    }

    public double getRingWidth() {
        return this.ringWidth;
    }

    public void setBaseAmount(double d) {
        this.baseAmount = d;
    }

    public double getBaseAmount() {
        return this.baseAmount;
    }

    public void setRingAmount(double d) {
        this.ringAmount = d;
    }

    public double getRingAmount() {
        return this.ringAmount;
    }

    public void setRayAmount(double d) {
        this.rayAmount = d;
    }

    public double getRayAmount() {
        return this.rayAmount;
    }

    public void setRadius(int n) {
        this.radius = n;
        this.sigma = (double)n / 3.0;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setDimensions(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.radius = (int)((double)Math.min(n / 2, n2 / 2) - this.ringWidth - this.falloff);
        this.centreX = n / 2;
        this.centreY = n2 / 2;
        super.setDimensions(n, n2);
    }

    public int filterRGB(int n, int n2, int n3) {
        double d;
        double d2 = n - this.centreX;
        double d3 = n2 - this.centreY;
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        double d5 = Math.exp(-d4 * d4 * this.gauss) * this.mix + Math.exp(-d4 * this.linear) * (1.0 - this.mix);
        d5 *= this.baseAmount;
        if (d4 > (double)this.radius + this.ringWidth) {
            d5 = ImageMath.lerp((d4 - ((double)this.radius + this.ringWidth)) / this.falloff, d5, 0.0);
        }
        if (d4 < (double)this.radius - this.ringWidth || d4 > (double)this.radius + this.ringWidth) {
            d = 0.0;
        } else {
            d = Math.abs(d4 - (double)this.radius) / this.ringWidth;
            d = 1.0 - d * d * (3.0 - 2.0 * d);
            d *= this.ringAmount;
        }
        d5 += d;
        double d6 = Math.atan2(d2, d3) + Math.PI;
        d6 = (ImageMath.mod(d6 / Math.PI * 17.0 + 1.0 + Noise.noise1(d6 * 10.0), 1.0) - 0.5) * 2.0;
        d6 = Math.abs(d6);
        d6 = Math.pow(d6, 5.0);
        double d7 = this.rayAmount * d6 / (1.0 + d4 * 0.1);
        d5 += d7;
        d5 = ImageMath.clamp(d5, 0.0, 1.0);
        return ImageMath.mixColors(d5, n3, this.color);
    }

    public String toString() {
        return "Stylize/Flare...";
    }
}

