/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.com.jhlabs.image;

import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.io.Serializable;
import java.util.Random;
import jj.play.ns.com.jhlabs.image.Colormap;
import jj.play.ns.com.jhlabs.image.Gradient;
import jj.play.ns.com.jhlabs.image.ImageMath;
import jj.play.ns.com.jhlabs.image.MutatableFilter;
import jj.play.ns.com.jhlabs.image.PixelUtils;
import jj.play.ns.com.jhlabs.math.FBM;
import jj.play.ns.com.jhlabs.math.Noise;
import jj.play.ns.com.jhlabs.math.RidgedFBM;
import jj.play.ns.com.jhlabs.math.VLNoise;

public class FBMFilter
extends RGBImageFilter
implements MutatableFilter,
Cloneable,
Serializable {
    public static final int NOISE = 0;
    public static final int RIDGED = 1;
    public static final int VLNOISE = 2;
    private double scale = 32.0;
    private double stretch = 1.0;
    private double angle = 0.0;
    private double amount = 1.0;
    private double H = 1.0;
    private double octaves = 4.0;
    private double lacunarity = 2.5;
    private double gain = 0.5;
    private double bias = 0.5;
    private int operation;
    private double m00 = 1.0;
    private double m01 = 0.0;
    private double m10 = 0.0;
    private double m11 = 1.0;
    private double min;
    private double max;
    private Colormap colormap = new Gradient();
    private boolean ridged;
    private FBM fBm;
    protected Random random = new Random();
    private int basisType = 0;

    public void setAmount(double d) {
        this.amount = d;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setOperation(int n) {
        this.operation = n;
    }

    public int getOperation() {
        return this.operation;
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public double getScale() {
        return this.scale;
    }

    public void setStretch(double d) {
        this.stretch = d;
    }

    public double getStretch() {
        return this.stretch;
    }

    public void setAngle(double d) {
        this.angle = d;
        double d2 = Math.cos(this.angle);
        double d3 = Math.sin(this.angle);
        this.m00 = d2;
        this.m01 = d3;
        this.m10 = -d3;
        this.m11 = d2;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setOctaves(double d) {
        this.octaves = d;
        this.fBm = this.makeFBM(this.H, d, this.lacunarity);
    }

    public double getOctaves() {
        return this.octaves;
    }

    public void setH(double d) {
        this.H = d;
        this.fBm = this.makeFBM(d, this.octaves, this.lacunarity);
    }

    public double getH() {
        return this.H;
    }

    public void setLacunarity(double d) {
        this.lacunarity = d;
        this.fBm = this.makeFBM(this.H, this.octaves, d);
    }

    public double getLacunarity() {
        return this.lacunarity;
    }

    public void setGain(double d) {
        this.gain = d;
    }

    public double getGain() {
        return this.gain;
    }

    public void setBias(double d) {
        this.bias = d;
    }

    public double getBias() {
        return this.bias;
    }

    public void setColormap(Colormap colormap) {
        this.colormap = colormap;
    }

    public Colormap getColormap() {
        return this.colormap;
    }

    public void setDimensions(int n, int n2) {
        super.setDimensions(n, n2);
        this.fBm = this.makeFBM(this.H, this.octaves, this.lacunarity);
    }

    public void setBasisType(int n) {
        this.basisType = n;
    }

    public int getBasisType() {
        return this.basisType;
    }

    protected FBM makeFBM(double d, double d2, double d3) {
        FBM fBM;
        switch (this.basisType) {
            default: {
                fBM = new FBM(d, d3, d2);
                break;
            }
            case 1: {
                fBM = new RidgedFBM(d, d3, d2);
                break;
            }
            case 2: {
                fBM = new VLNoise(d, d3, d2);
            }
        }
        double[] dArray = Noise.findRange(fBM, null);
        this.min = dArray[0];
        this.max = dArray[1];
        return fBM;
    }

    public int filterRGB(int n, int n2, int n3) {
        int n4;
        double d = this.m00 * (double)n + this.m01 * (double)n2;
        double d2 = this.m10 * (double)n + this.m11 * (double)n2;
        double d3 = this.fBm.evaluate(d /= this.scale, d2 /= this.scale * this.stretch);
        d3 = (d3 - this.min) / (this.max - this.min);
        d3 = ImageMath.gain(d3, this.gain);
        d3 = ImageMath.bias(d3, this.bias);
        d3 *= this.amount;
        int n5 = n3 & 0xFF000000;
        if (this.colormap != null) {
            n4 = this.colormap.getColor(d3);
        } else {
            n4 = PixelUtils.clamp((int)(d3 * 255.0));
            int n6 = n4 << 16;
            int n7 = n4 << 8;
            int n8 = n4;
            n4 = n5 | n6 | n7 | n8;
        }
        if (this.operation != 0) {
            n4 = PixelUtils.combinePixels(n3, n4, this.operation);
        }
        return n4;
    }

    public void mutate(int n, ImageFilter imageFilter, boolean bl, boolean bl2) {
        FBMFilter fBMFilter = (FBMFilter)imageFilter;
        if (bl || n == 0) {
            fBMFilter.setScale(this.getScale());
            fBMFilter.setAngle(this.getAngle());
            fBMFilter.setStretch(this.getStretch());
            fBMFilter.setAmount(this.getAmount());
            fBMFilter.setLacunarity(this.getLacunarity());
            fBMFilter.setOctaves(this.getOctaves());
            fBMFilter.setH(this.getH());
            fBMFilter.setGain(this.getGain());
            fBMFilter.setBias(this.getBias());
            fBMFilter.setColormap(this.getColormap());
        } else {
            fBMFilter.scale = this.mutate(this.scale, 0.6, 4.0, 3.0, 64.0);
            fBMFilter.setAngle(this.mutate(this.angle, 0.6, 1.5707963267948966));
            fBMFilter.stretch = this.mutate(this.stretch, 0.6, 5.0, 1.0, 10.0);
            fBMFilter.amount = this.mutate(n, 0.6, 0.2, 0.0, 1.0);
            fBMFilter.lacunarity = this.mutate(this.lacunarity, 0.5, 0.5, 0.0, 3.0);
            fBMFilter.octaves = this.mutate(this.octaves, 0.9, 0.2, 0.0, 12.0);
            fBMFilter.H = this.mutate(this.H, 0.7, 0.2, 0.0, 1.0);
            fBMFilter.gain = this.mutate(this.gain, 0.2, 0.2, 0.0, 1.0);
            fBMFilter.bias = this.mutate(this.bias, 0.2, 0.2, 0.0, 1.0);
        }
        if (bl2 || n == 0) {
            fBMFilter.setColormap(this.getColormap());
        } else {
            fBMFilter.setColormap(Gradient.randomGradient());
        }
    }

    private double mutate(double d, double d2, double d3, double d4, double d5) {
        if (this.random.nextDouble() >= d2) {
            return d;
        }
        return ImageMath.clamp(d + d3 * this.random.nextGaussian(), d4, d5);
    }

    private double mutate(double d, double d2, double d3) {
        if (this.random.nextDouble() >= d2) {
            return d;
        }
        return d + d3 * this.random.nextGaussian();
    }

    public Object clone() {
        FBMFilter fBMFilter = (FBMFilter)super.clone();
        fBMFilter.fBm = this.makeFBM(fBMFilter.H, fBMFilter.octaves, fBMFilter.lacunarity);
        return fBMFilter;
    }

    public String toString() {
        return "Texture/Fractal Brownian Motion...";
    }
}

