/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.spdy;

import java.util.List;
import java.util.Map;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.spdy.DefaultSpdyDataFrame;
import org.jboss.netty.handler.codec.spdy.DefaultSpdyHeadersFrame;
import org.jboss.netty.handler.codec.spdy.DefaultSpdySynReplyFrame;
import org.jboss.netty.handler.codec.spdy.DefaultSpdySynStreamFrame;
import org.jboss.netty.handler.codec.spdy.SpdyHeaders;
import org.jboss.netty.handler.codec.spdy.SpdyHttpHeaders;
import org.jboss.netty.handler.codec.spdy.SpdySynReplyFrame;
import org.jboss.netty.handler.codec.spdy.SpdySynStreamFrame;

public class SpdyHttpEncoder
implements ChannelDownstreamHandler {
    private volatile int currentStreamID;

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        if (!(evt instanceof MessageEvent)) {
            ctx.sendDownstream(evt);
            return;
        }
        MessageEvent e = (MessageEvent)evt;
        Object msg = e.getMessage();
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            SpdySynStreamFrame spdySynStreamFrame = this.createSynStreamFrame(httpRequest);
            int streamID = spdySynStreamFrame.getStreamID();
            ChannelFuture future = this.getContentFuture(ctx, e, streamID, httpRequest);
            Channels.write(ctx, future, spdySynStreamFrame, e.getRemoteAddress());
        } else if (msg instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)msg;
            if (httpResponse.containsHeader("X-SPDY-Associated-To-Stream-ID")) {
                SpdySynStreamFrame spdySynStreamFrame = this.createSynStreamFrame(httpResponse);
                int streamID = spdySynStreamFrame.getStreamID();
                ChannelFuture future = this.getContentFuture(ctx, e, streamID, httpResponse);
                Channels.write(ctx, future, spdySynStreamFrame, e.getRemoteAddress());
            } else {
                SpdySynReplyFrame spdySynReplyFrame = this.createSynReplyFrame(httpResponse);
                int streamID = spdySynReplyFrame.getStreamID();
                ChannelFuture future = this.getContentFuture(ctx, e, streamID, httpResponse);
                Channels.write(ctx, future, spdySynReplyFrame, e.getRemoteAddress());
            }
        } else if (msg instanceof HttpChunk) {
            HttpChunk chunk = (HttpChunk)msg;
            DefaultSpdyDataFrame spdyDataFrame = new DefaultSpdyDataFrame(this.currentStreamID);
            spdyDataFrame.setData(chunk.getContent());
            spdyDataFrame.setLast(chunk.isLast());
            if (chunk instanceof HttpChunkTrailer) {
                HttpChunkTrailer trailer = (HttpChunkTrailer)chunk;
                List<Map.Entry<String, String>> trailers = trailer.getHeaders();
                if (trailers.isEmpty()) {
                    Channels.write(ctx, e.getFuture(), spdyDataFrame, e.getRemoteAddress());
                } else {
                    DefaultSpdyHeadersFrame spdyHeadersFrame = new DefaultSpdyHeadersFrame(this.currentStreamID);
                    for (Map.Entry<String, String> entry : trailers) {
                        spdyHeadersFrame.addHeader(entry.getKey(), entry.getValue());
                    }
                    ChannelFuture future = Channels.future(e.getChannel());
                    future.addListener(new SpdyFrameWriter(ctx, e, spdyDataFrame));
                    Channels.write(ctx, future, spdyHeadersFrame, e.getRemoteAddress());
                }
            } else {
                Channels.write(ctx, e.getFuture(), spdyDataFrame, e.getRemoteAddress());
            }
        } else {
            ctx.sendDownstream(evt);
        }
    }

    private ChannelFuture getContentFuture(ChannelHandlerContext ctx, MessageEvent e, int streamID, HttpMessage httpMessage) {
        if (httpMessage.getContent().readableBytes() == 0) {
            return e.getFuture();
        }
        DefaultSpdyDataFrame spdyDataFrame = new DefaultSpdyDataFrame(streamID);
        spdyDataFrame.setData(httpMessage.getContent());
        spdyDataFrame.setLast(true);
        ChannelFuture future = Channels.future(e.getChannel());
        future.addListener(new SpdyFrameWriter(ctx, e, spdyDataFrame));
        return future;
    }

    private SpdySynStreamFrame createSynStreamFrame(HttpMessage httpMessage) throws Exception {
        boolean chunked = httpMessage.isChunked();
        int streamID = SpdyHttpHeaders.getStreamID(httpMessage);
        int associatedToStreamID = SpdyHttpHeaders.getAssociatedToStreamID(httpMessage);
        byte priority = SpdyHttpHeaders.getPriority(httpMessage);
        String URL2 = SpdyHttpHeaders.getUrl(httpMessage);
        SpdyHttpHeaders.removeStreamID(httpMessage);
        SpdyHttpHeaders.removeAssociatedToStreamID(httpMessage);
        SpdyHttpHeaders.removePriority(httpMessage);
        SpdyHttpHeaders.removeUrl(httpMessage);
        httpMessage.removeHeader("Connection");
        httpMessage.removeHeader("Keep-Alive");
        httpMessage.removeHeader("Proxy-Connection");
        httpMessage.removeHeader("Transfer-Encoding");
        DefaultSpdySynStreamFrame spdySynStreamFrame = new DefaultSpdySynStreamFrame(streamID, associatedToStreamID, priority);
        for (Map.Entry<String, String> entry : httpMessage.getHeaders()) {
            spdySynStreamFrame.addHeader(entry.getKey(), entry.getValue());
        }
        SpdyHeaders.setVersion(spdySynStreamFrame, httpMessage.getProtocolVersion());
        if (httpMessage instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)httpMessage;
            SpdyHeaders.setMethod(spdySynStreamFrame, httpRequest.getMethod());
            SpdyHeaders.setUrl(spdySynStreamFrame, httpRequest.getUri());
        }
        if (httpMessage instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)httpMessage;
            SpdyHeaders.setStatus(spdySynStreamFrame, httpResponse.getStatus());
            SpdyHeaders.setUrl(spdySynStreamFrame, URL2);
            spdySynStreamFrame.setUnidirectional(true);
        }
        if (chunked) {
            this.currentStreamID = streamID;
            spdySynStreamFrame.setLast(false);
        } else {
            spdySynStreamFrame.setLast(httpMessage.getContent().readableBytes() == 0);
        }
        return spdySynStreamFrame;
    }

    private SpdySynReplyFrame createSynReplyFrame(HttpResponse httpResponse) throws Exception {
        boolean chunked = httpResponse.isChunked();
        int streamID = SpdyHttpHeaders.getStreamID(httpResponse);
        SpdyHttpHeaders.removeStreamID(httpResponse);
        httpResponse.removeHeader("Connection");
        httpResponse.removeHeader("Keep-Alive");
        httpResponse.removeHeader("Proxy-Connection");
        httpResponse.removeHeader("Transfer-Encoding");
        DefaultSpdySynReplyFrame spdySynReplyFrame = new DefaultSpdySynReplyFrame(streamID);
        for (Map.Entry<String, String> entry : httpResponse.getHeaders()) {
            spdySynReplyFrame.addHeader(entry.getKey(), entry.getValue());
        }
        SpdyHeaders.setStatus(spdySynReplyFrame, httpResponse.getStatus());
        SpdyHeaders.setVersion(spdySynReplyFrame, httpResponse.getProtocolVersion());
        if (chunked) {
            this.currentStreamID = streamID;
            spdySynReplyFrame.setLast(false);
        } else {
            spdySynReplyFrame.setLast(httpResponse.getContent().readableBytes() == 0);
        }
        return spdySynReplyFrame;
    }

    private class SpdyFrameWriter
    implements ChannelFutureListener {
        private final ChannelHandlerContext ctx;
        private final MessageEvent e;
        private final Object spdyFrame;

        SpdyFrameWriter(ChannelHandlerContext ctx, MessageEvent e, Object spdyFrame) {
            this.ctx = ctx;
            this.e = e;
            this.spdyFrame = spdyFrame;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                Channels.write(this.ctx, this.e.getFuture(), this.spdyFrame, this.e.getRemoteAddress());
            } else if (future.isCancelled()) {
                this.e.getFuture().cancel();
            } else {
                this.e.getFuture().setFailure(future.getCause());
            }
        }
    }
}

