/*
 * Decompiled with CFR 0.152.
 */
package jj.play.org.eclipse.mylyn.wikitext.core.parser.markup.token;

import jj.play.org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElementProcessor;

public class EntityWrappingReplacementToken
extends PatternBasedElement {
    private final String delimiter;
    private final String leftEntity;
    private final String rightEntity;

    public EntityWrappingReplacementToken(String delimiter, String leftEntity, String rightEntity) {
        this.delimiter = delimiter;
        this.leftEntity = leftEntity;
        this.rightEntity = rightEntity;
        if (delimiter.length() != 1) {
            throw new IllegalArgumentException(delimiter);
        }
    }

    public String getPattern(int groupOffset) {
        String quoted = Character.isLetterOrDigit(this.delimiter.charAt(0)) ? this.delimiter : "\\" + this.delimiter;
        return "(?:(?:(?<=\\W)|^)" + quoted + "([^" + quoted + "]+)" + quoted + "(?=\\W))";
    }

    protected int getPatternGroupCount() {
        return 1;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new EntityWrappingReplacementTokenProcessor(this.leftEntity, this.rightEntity);
    }

    private static class EntityWrappingReplacementTokenProcessor
    extends PatternBasedElementProcessor {
        private final String leftEntity;
        private final String rightEntity;

        public EntityWrappingReplacementTokenProcessor(String leftEntity, String rightEntity) {
            this.leftEntity = leftEntity;
            this.rightEntity = rightEntity;
        }

        public void emit() {
            String content = this.group(1);
            this.builder.entityReference(this.leftEntity);
            this.builder.characters(content);
            this.builder.entityReference(this.rightEntity);
        }
    }
}

