/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.logging;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.sf.oval.internal.util.Assert;
import net.sf.oval.logging.Logger;

public class LoggerJDKImpl
implements Logger {
    private final java.util.logging.Logger jdkLogger;
    private final String name;

    public LoggerJDKImpl(String name) throws IllegalArgumentException {
        Assert.notNull("name", name);
        this.name = name;
        this.jdkLogger = java.util.logging.Logger.getLogger(name);
    }

    public void debug(String msg) {
        this.log(Level.FINE, msg, null);
    }

    public void debug(String msg, Throwable t) {
        this.log(Level.FINE, msg, t);
    }

    public void error(String msg) {
        this.log(Level.SEVERE, msg, null);
    }

    public void error(String msg, Throwable t) {
        this.log(Level.SEVERE, msg, t);
    }

    public void info(String msg) {
        this.log(Level.INFO, msg, null);
    }

    public void info(String msg, Throwable t) {
        this.log(Level.INFO, msg, t);
    }

    public boolean isDebug() {
        return this.jdkLogger.isLoggable(Level.FINE);
    }

    public boolean isError() {
        return this.jdkLogger.isLoggable(Level.SEVERE);
    }

    public boolean isInfo() {
        return this.jdkLogger.isLoggable(Level.INFO);
    }

    public boolean isTrace() {
        return this.jdkLogger.isLoggable(Level.FINEST);
    }

    public boolean isWarn() {
        return this.jdkLogger.isLoggable(Level.WARNING);
    }

    private void log(Level level, String msg, Throwable t) {
        LogRecord record = new LogRecord(level, msg);
        record.setLoggerName(this.name);
        record.setThrown(t);
        StackTraceElement[] steArray = new Throwable().getStackTrace();
        record.setSourceClassName(steArray[2].getClassName());
        record.setSourceMethodName(steArray[2].getMethodName());
        this.jdkLogger.log(record);
    }

    public void trace(String msg) {
        this.log(Level.FINEST, msg, null);
    }

    public void trace(String msg, Throwable t) {
        this.log(Level.FINEST, msg, t);
    }

    public void warn(String msg) {
        this.log(Level.WARNING, msg, null);
    }

    public void warn(String msg, Throwable t) {
        this.log(Level.WARNING, msg, t);
    }
}

