/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.internal.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.sf.oval.internal.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayUtils {
    public static final Method[] EMPTY_METHOD_ARRAY = new Method[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static <T> int addAll(Collection<T> collection, T ... elements) throws IllegalArgumentException {
        Assert.notNull("collection", collection);
        if (elements == null) {
            return 0;
        }
        int count = 0;
        T[] TArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            T elem = TArray[n2];
            if (collection.add(elem)) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public static List<Object> arrayToList(Object array) {
        Assert.notNull("array", array);
        if (array instanceof Object[]) {
            return Arrays.asList((Object[])array);
        }
        if (array instanceof byte[]) {
            byte[] arrayCasted = (byte[])array;
            ArrayList<Object> result = new ArrayList<Object>(arrayCasted.length);
            byte[] byArray = arrayCasted;
            int n = arrayCasted.length;
            int n2 = 0;
            while (n2 < n) {
                byte i = byArray[n2];
                result.add(i);
                ++n2;
            }
            return result;
        }
        if (array instanceof char[]) {
            char[] arrayCasted = (char[])array;
            ArrayList<Object> result = new ArrayList<Object>(arrayCasted.length);
            char[] cArray = arrayCasted;
            int n = arrayCasted.length;
            int n3 = 0;
            while (n3 < n) {
                char i = cArray[n3];
                result.add(Character.valueOf(i));
                ++n3;
            }
            return result;
        }
        if (array instanceof short[]) {
            short[] arrayCasted = (short[])array;
            ArrayList<Object> result = new ArrayList<Object>(arrayCasted.length);
            short[] sArray = arrayCasted;
            int n = arrayCasted.length;
            int n4 = 0;
            while (n4 < n) {
                short i = sArray[n4];
                result.add(i);
                ++n4;
            }
            return result;
        }
        if (array instanceof int[]) {
            int[] arrayCasted = (int[])array;
            ArrayList<Object> result = new ArrayList<Object>(arrayCasted.length);
            int[] nArray = arrayCasted;
            int n = arrayCasted.length;
            int n5 = 0;
            while (n5 < n) {
                int i = nArray[n5];
                result.add(i);
                ++n5;
            }
            return result;
        }
        if (array instanceof long[]) {
            long[] arrayCasted = (long[])array;
            ArrayList<Object> result = new ArrayList<Object>(arrayCasted.length);
            long[] lArray = arrayCasted;
            int n = arrayCasted.length;
            int n6 = 0;
            while (n6 < n) {
                long i = lArray[n6];
                result.add(i);
                ++n6;
            }
            return result;
        }
        if (array instanceof double[]) {
            double[] arrayCasted = (double[])array;
            ArrayList<Object> result = new ArrayList<Object>(arrayCasted.length);
            double[] dArray = arrayCasted;
            int n = arrayCasted.length;
            int n7 = 0;
            while (n7 < n) {
                double i = dArray[n7];
                result.add(i);
                ++n7;
            }
            return result;
        }
        if (array instanceof float[]) {
            float[] arrayCasted = (float[])array;
            ArrayList<Object> result = new ArrayList<Object>(arrayCasted.length);
            float[] fArray = arrayCasted;
            int n = arrayCasted.length;
            int n8 = 0;
            while (n8 < n) {
                float i = fArray[n8];
                result.add(Float.valueOf(i));
                ++n8;
            }
            return result;
        }
        if (array instanceof boolean[]) {
            boolean[] arrayCasted = (boolean[])array;
            ArrayList<Object> result = new ArrayList<Object>(arrayCasted.length);
            boolean[] blArray = arrayCasted;
            int n = arrayCasted.length;
            int n9 = 0;
            while (n9 < n) {
                boolean i = blArray[n9];
                result.add(i);
                ++n9;
            }
            return result;
        }
        throw new IllegalArgumentException("Parameter [array] must be an array");
    }

    public static <T> boolean containsEqual(T[] theArray, T theItem) {
        T[] TArray = theArray;
        int n = theArray.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            if (t == theItem) {
                return true;
            }
            if (t != null && t.equals(theItem)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <T> boolean containsSame(T[] theArray, T theItem) {
        T[] TArray = theArray;
        int n = theArray.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            if (t == theItem) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private ArrayUtils() {
    }
}

