/*
 * Decompiled with CFR 0.152.
 */
package org.playframework.playclipse.builder;

import fr.zenexity.pdt.editors.IO;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.playframework.playclipse.builder.ErrorChecker;

public class RouteChecker
extends ErrorChecker {
    private static Pattern comment = Pattern.compile("^\\s*#");
    private static Pattern empty = Pattern.compile("\\s*");
    private static Pattern METHOD = Pattern.compile("(\\*|GET|POST|PUT|DELETE|UPDATE|HEAD)");

    public RouteChecker(IFile file, String preference) {
        super(file, preference);
    }

    @Override
    public void check() {
        if (this.getSeverity() < 0) {
            return;
        }
        try {
            IO.readLines(this.file, new IO.LineReader(){

                @Override
                public void readLine(String line, int lineNumber, int offset) {
                    if (comment.matcher(line).find()) {
                        return;
                    }
                    if (line.isEmpty() || empty.matcher(line).matches()) {
                        return;
                    }
                    try {
                        RouteChecker.this.checkLine(line, lineNumber, offset);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception exception) {}
    }

    private void checkLine(String line, int lineNumber, int offset) throws CoreException {
        String[] rule = line.split("\\s+");
        if (rule.length != 3) {
            this.addMarker("Invalid route syntax", lineNumber, this.getSeverity(), offset, offset + line.length());
            return;
        }
        String method = rule[0];
        String action = rule[2];
        if (!METHOD.matcher(method).matches()) {
            this.addMarker("Invalid method", lineNumber, this.getSeverity(), offset, offset + method.length());
        }
        if (action.indexOf(":") == -1 && action.indexOf("{") == -1 && this.getInspector().resolveAction(action) == null) {
            int start = offset + line.indexOf(action);
            this.addMarker("Missing route: " + action, lineNumber, this.getSeverity(), start, start + action.length());
        }
    }
}

