/*
 * Decompiled with CFR 0.152.
 */
package fr.zenexity.pdt.editors;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public final class EditorHelper {
    public ITextEditor textEditor;

    public EditorHelper(ITextEditor textEditor) {
        this.textEditor = textEditor;
    }

    public static EditorHelper getCurrent(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editor instanceof ITextEditor) {
            return new EditorHelper((ITextEditor)editor);
        }
        return null;
    }

    public IProject getProject() {
        IFile curfile = ((IFileEditorInput)this.textEditor.getEditorInput()).getFile();
        IContainer container = curfile.getParent();
        while (container != null) {
            if (container instanceof IProject) {
                return (IProject)container;
            }
            container = container.getParent();
        }
        return null;
    }

    public IContainer getFirstParentFor(String name) {
        IFile curfile = ((IFileEditorInput)this.textEditor.getEditorInput()).getFile();
        IContainer container = curfile.getParent();
        while (container != null) {
            if (container.getName().equals(name)) {
                return container;
            }
            container = container.getParent();
        }
        return null;
    }

    public IWorkbenchWindow getWindow() {
        return this.textEditor.getSite().getWorkbenchWindow();
    }

    public int getCurrentLineNo() {
        return this.getTextSelection().getStartLine();
    }

    public int lineCount() {
        return this.getDocument().getNumberOfLines();
    }

    public String getTitle() {
        return this.textEditor.getTitle();
    }

    public String enclosingDirectory() {
        IPath path = this.getFilePath();
        return path.segment(path.segmentCount() - 2);
    }

    protected IPath getFilePath() {
        return ((IFileEditorInput)this.textEditor.getEditorInput()).getFile().getFullPath();
    }

    public String getLine(int lineNo) {
        IDocument doc = this.getDocument();
        try {
            return doc.get(doc.getLineOffset(lineNo), doc.getLineLength(lineNo));
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public String getCurrentLine() {
        return this.getLine(this.getCurrentLineNo());
    }

    private ITextSelection getTextSelection() {
        return (ITextSelection)this.textEditor.getSelectionProvider().getSelection();
    }

    public IDocument getDocument() {
        return this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput());
    }

    public int getLineNumber(int offset) throws BadLocationException {
        IDocument doc = this.getDocument();
        return doc.getLineOfOffset(offset);
    }
}

