/*
 * Decompiled with CFR 0.152.
 */
package jj.play.org.eclipse.mylyn.wikitext.core.parser.markup.block;

import java.util.regex.Pattern;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.Attributes;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.markup.Block;

public class JavaStackTraceBlock
extends Block {
    private static final String PACKAGE_PART = "([a-z][a-z0-9]*)";
    private static final String CLASS_PART = "([A-Za-z][a-z0-9_$]*)+";
    private static final String FQN_PART = "([a-z][a-z0-9]*)(\\.([a-z][a-z0-9]*))*\\.([A-Za-z][a-z0-9_$]*)+";
    private static final String START_PART = "(Caused by:\\s+)?([a-z][a-z0-9]*)(\\.([a-z][a-z0-9]*))*\\.([A-Za-z][a-z0-9_$]*)+(:\\s+\\w.*)?";
    private static final String CONTINUE_PART = "(at\\s+([a-z][a-z0-9]*)(\\.([a-z][a-z0-9]*))*\\.([A-Za-z][a-z0-9_$]*)+\\.((\\<init\\>)|([a-zA-Z0-9_$]+))\\(.*?\\)))|\\.{3}\\s\\d+\\smore";
    private static final Pattern STACK_TRACE_PATTERN = Pattern.compile("\\s*(((Caused by:\\s+)?([a-z][a-z0-9]*)(\\.([a-z][a-z0-9]*))*\\.([A-Za-z][a-z0-9_$]*)+(:\\s+\\w.*)?)|((at\\s+([a-z][a-z0-9]*)(\\.([a-z][a-z0-9]*))*\\.([A-Za-z][a-z0-9_$]*)+\\.((\\<init\\>)|([a-zA-Z0-9_$]+))\\(.*?\\)))|\\.{3}\\s\\d+\\smore)");
    private int blockLineCount = 0;

    public boolean canStart(String line, int lineOffset) {
        if (lineOffset == 0 && STACK_TRACE_PATTERN.matcher(line).matches()) {
            this.blockLineCount = 0;
            return true;
        }
        return false;
    }

    protected int processLineContent(String line, int offset) {
        if (this.blockLineCount++ == 0) {
            Attributes attributes = new Attributes();
            attributes.setCssClass("javaStackTrace");
            this.builder.beginBlock(DocumentBuilder.BlockType.PREFORMATTED, attributes);
        } else if (!STACK_TRACE_PATTERN.matcher(line).matches()) {
            this.setClosed(true);
            return 0;
        }
        this.builder.characters(offset > 0 ? line.substring(offset) : line);
        this.builder.characters("\n");
        return -1;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

