/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.io.IOException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.socket.Worker;
import org.jboss.netty.channel.socket.nio.AbstractNioChannel;
import org.jboss.netty.channel.socket.nio.NioProviderMetadata;
import org.jboss.netty.channel.socket.nio.SelectorUtil;
import org.jboss.netty.channel.socket.nio.SocketSendBufferPool;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.ExternalResourceReleasable;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.jboss.netty.util.internal.DeadLockProofWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractNioWorker
implements Worker,
ExternalResourceReleasable {
    private static final AtomicInteger nextId = new AtomicInteger();
    final int id = nextId.incrementAndGet();
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractNioWorker.class);
    private static final int CONSTRAINT_LEVEL = NioProviderMetadata.CONSTRAINT_LEVEL;
    static final int CLEANUP_INTERVAL = 256;
    private final Executor executor;
    protected volatile Thread thread;
    volatile Selector selector;
    protected final AtomicBoolean wakenUp = new AtomicBoolean();
    private final ReadWriteLock selectorGuard = new ReentrantReadWriteLock();
    private final Object startStopLock = new Object();
    private final Queue<Runnable> registerTaskQueue = new ConcurrentLinkedQueue<Runnable>();
    protected final Queue<Runnable> writeTaskQueue = new ConcurrentLinkedQueue<Runnable>();
    private final Queue<Runnable> eventQueue = new ConcurrentLinkedQueue<Runnable>();
    private volatile int cancelledKeys;
    protected final SocketSendBufferPool sendBufferPool = new SocketSendBufferPool();

    AbstractNioWorker(Executor executor) {
        this.executor = executor;
        this.openSelector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(AbstractNioChannel<?> channel, ChannelFuture future) {
        Object object = this.startStopLock;
        synchronized (object) {
            if (this.selector == null) {
                throw new RejectedExecutionException("Worker has already been shutdown");
            }
            Runnable registerTask = this.createRegisterTask(channel, future);
            boolean offered = this.registerTaskQueue.offer(registerTask);
            assert (offered);
            if (this.wakenUp.compareAndSet(false, true)) {
                this.selector.wakeup();
            }
        }
    }

    private Selector recreateSelector() throws IOException {
        Selector newSelector;
        block6: {
            newSelector = Selector.open();
            Selector selector = this.selector;
            this.selector = newSelector;
            for (SelectionKey key : selector.keys()) {
                SelectableChannel ch = key.channel();
                int ops = key.interestOps();
                Object att = key.attachment();
                key.cancel();
                try {
                    ch.register(newSelector, ops, att);
                }
                catch (ClosedChannelException e) {
                    AbstractNioChannel channel = (AbstractNioChannel)att;
                    this.close(channel, Channels.succeededFuture(channel));
                }
            }
            try {
                selector.close();
            }
            catch (Throwable t) {
                if (!logger.isWarnEnabled()) break block6;
                logger.warn("Failed to close a selector.", t);
            }
        }
        if (logger.isWarnEnabled()) {
            logger.warn("Recreated Selector because of possible jdk epoll(..) bug");
        }
        return newSelector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openSelector() {
        block9: {
            try {
                this.selector = Selector.open();
            }
            catch (Throwable t) {
                throw new ChannelException("Failed to create a selector.", t);
            }
            boolean success = false;
            try {
                DeadLockProofWorker.start(this.executor, new ThreadRenamingRunnable(this, "New I/O  worker #" + this.id));
                success = true;
                Object var3_3 = null;
                if (success) break block9;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                if (!success) {
                    try {
                        this.selector.close();
                    }
                    catch (Throwable t) {
                        logger.warn("Failed to close a selector.", t);
                    }
                    this.selector = null;
                }
                throw throwable;
            }
            try {
                this.selector.close();
            }
            catch (Throwable t) {
                logger.warn("Failed to close a selector.", t);
            }
            this.selector = null;
            {
            }
        }
        assert (this.selector != null && this.selector.isOpen());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.thread = Thread.currentThread();
        boolean shutdown = false;
        int selectReturnsImmediately = 0;
        Selector selector = this.selector;
        long minSelectTimeout = SelectorUtil.SELECT_TIMEOUT_NANOS * 80L / 100L;
        boolean wakenupFromLoop = false;
        while (true) {
            this.wakenUp.set(false);
            if (CONSTRAINT_LEVEL != 0) {
                this.selectorGuard.writeLock().lock();
                this.selectorGuard.writeLock().unlock();
            }
            try {
                long beforeSelect = System.nanoTime();
                int selected = SelectorUtil.select(selector);
                if (SelectorUtil.EPOLL_BUG_WORKAROUND && selected == 0 && !wakenupFromLoop && !this.wakenUp.get()) {
                    long timeBlocked = System.nanoTime() - beforeSelect;
                    if (timeBlocked < minSelectTimeout) {
                        boolean notConnected = false;
                        for (SelectionKey key : selector.keys()) {
                            SelectableChannel ch = key.channel();
                            try {
                                if ((!(ch instanceof DatagramChannel) || ((DatagramChannel)ch).isConnected()) && (!(ch instanceof SocketChannel) || ((SocketChannel)ch).isConnected())) continue;
                                notConnected = true;
                                key.cancel();
                            }
                            catch (CancelledKeyException e) {}
                        }
                        selectReturnsImmediately = notConnected ? 0 : ++selectReturnsImmediately;
                    } else {
                        selectReturnsImmediately = 0;
                    }
                    if (selectReturnsImmediately == 1024) {
                        selector = this.recreateSelector();
                        selectReturnsImmediately = 0;
                        wakenupFromLoop = false;
                        continue;
                    }
                } else {
                    selectReturnsImmediately = 0;
                }
                if (this.wakenUp.get()) {
                    wakenupFromLoop = true;
                    selector.wakeup();
                } else {
                    wakenupFromLoop = false;
                }
                this.cancelledKeys = 0;
                this.processRegisterTaskQueue();
                this.processEventQueue();
                this.processWriteTaskQueue();
                this.processSelectedKeys(selector.selectedKeys());
                if (selector.keys().isEmpty()) {
                    if (!shutdown && (!(this.executor instanceof ExecutorService) || !((ExecutorService)this.executor).isShutdown())) continue;
                    Object object = this.startStopLock;
                    synchronized (object) {
                        if (this.registerTaskQueue.isEmpty() && selector.keys().isEmpty()) {
                            try {
                                try {
                                    selector.close();
                                }
                                catch (IOException e) {
                                    logger.warn("Failed to close a selector.", e);
                                    Object var18_18 = null;
                                    this.selector = null;
                                }
                                Object var18_17 = null;
                                this.selector = null;
                            }
                            catch (Throwable throwable) {
                                Object var18_19 = null;
                                this.selector = null;
                                throw throwable;
                            }
                            break;
                        }
                        shutdown = false;
                        continue;
                    }
                }
                shutdown = false;
            }
            catch (Throwable t) {
                logger.warn("Unexpected exception in the selector loop.", t);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
        }
    }

    @Override
    public void executeInIoThread(Runnable task) {
        this.executeInIoThread(task, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeInIoThread(Runnable task, boolean alwaysAsync) {
        if (!alwaysAsync && Thread.currentThread() == this.thread) {
            task.run();
        } else {
            this.eventQueue.offer(task);
            Object object = this.startStopLock;
            synchronized (object) {
                Selector selector;
                if (this.selector == null) {
                    Runnable r;
                    while ((r = this.eventQueue.poll()) != null) {
                        r.run();
                    }
                } else if (this.wakenUp.compareAndSet(false, true) && (selector = this.selector) != null) {
                    selector.wakeup();
                }
            }
        }
    }

    private void processRegisterTaskQueue() throws IOException {
        Runnable task;
        while ((task = this.registerTaskQueue.poll()) != null) {
            task.run();
            this.cleanUpCancelledKeys();
        }
    }

    private void processWriteTaskQueue() throws IOException {
        Runnable task;
        while ((task = this.writeTaskQueue.poll()) != null) {
            task.run();
            this.cleanUpCancelledKeys();
        }
    }

    private void processEventQueue() throws IOException {
        Runnable task;
        while ((task = this.eventQueue.poll()) != null) {
            task.run();
            this.cleanUpCancelledKeys();
        }
    }

    private void processSelectedKeys(Set<SelectionKey> selectedKeys) throws IOException {
        if (selectedKeys.isEmpty()) {
            return;
        }
        Iterator<SelectionKey> i = selectedKeys.iterator();
        while (i.hasNext()) {
            SelectionKey k = i.next();
            i.remove();
            try {
                int readyOps = k.readyOps();
                if (((readyOps & 1) != 0 || readyOps == 0) && !this.read(k)) continue;
                if ((readyOps & 4) != 0) {
                    this.writeFromSelectorLoop(k);
                }
            }
            catch (CancelledKeyException e) {
                this.close(k);
            }
            if (!this.cleanUpCancelledKeys()) continue;
            break;
        }
    }

    private boolean cleanUpCancelledKeys() throws IOException {
        if (this.cancelledKeys >= 256) {
            this.cancelledKeys = 0;
            this.selector.selectNow();
            return true;
        }
        return false;
    }

    private void close(SelectionKey k) {
        AbstractNioChannel ch = (AbstractNioChannel)k.attachment();
        this.close(ch, Channels.succeededFuture(ch));
    }

    void writeFromUserCode(AbstractNioChannel<?> channel) {
        if (!channel.isConnected()) {
            AbstractNioWorker.cleanUpWriteBuffer(channel);
            return;
        }
        if (this.scheduleWriteIfNecessary(channel)) {
            return;
        }
        if (channel.writeSuspended) {
            return;
        }
        if (channel.inWriteNowLoop) {
            return;
        }
        this.write0(channel);
    }

    void writeFromTaskLoop(AbstractNioChannel<?> ch) {
        if (!ch.writeSuspended) {
            this.write0(ch);
        }
    }

    void writeFromSelectorLoop(SelectionKey k) {
        AbstractNioChannel ch = (AbstractNioChannel)k.attachment();
        ch.writeSuspended = false;
        this.write0(ch);
    }

    protected abstract boolean scheduleWriteIfNecessary(AbstractNioChannel<?> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write0(AbstractNioChannel<?> channel) {
        boolean open = true;
        boolean addOpWrite = false;
        boolean removeOpWrite = false;
        boolean iothread = AbstractNioWorker.isIoThread(channel);
        long writtenBytes = 0L;
        SocketSendBufferPool sendBufferPool = this.sendBufferPool;
        WritableByteChannel ch = (WritableByteChannel)channel.channel;
        Queue<MessageEvent> writeBuffer = channel.writeBufferQueue;
        int writeSpinCount = channel.getConfig().getWriteSpinCount();
        Object object = channel.writeLock;
        synchronized (object) {
            channel.inWriteNowLoop = true;
            while (true) {
                MessageEvent evt = channel.currentWriteEvent;
                SocketSendBufferPool.SendBuffer buf = null;
                ChannelFuture future = null;
                try {
                    if (evt == null) {
                        channel.currentWriteEvent = evt = writeBuffer.poll();
                        if (evt == null) {
                            removeOpWrite = true;
                            channel.writeSuspended = false;
                            break;
                        }
                        future = evt.getFuture();
                        channel.currentWriteBuffer = buf = sendBufferPool.acquire(evt.getMessage());
                    } else {
                        future = evt.getFuture();
                        buf = channel.currentWriteBuffer;
                    }
                    long localWrittenBytes = 0L;
                    for (int i = writeSpinCount; i > 0; --i) {
                        localWrittenBytes = buf.transferTo(ch);
                        if (localWrittenBytes != 0L) {
                            writtenBytes += localWrittenBytes;
                            break;
                        }
                        if (buf.finished()) break;
                    }
                    if (buf.finished()) {
                        buf.release();
                        channel.currentWriteEvent = null;
                        channel.currentWriteBuffer = null;
                        evt = null;
                        buf = null;
                        future.setSuccess();
                        continue;
                    }
                    addOpWrite = true;
                    channel.writeSuspended = true;
                    if (localWrittenBytes <= 0L) break;
                    future.setProgress(localWrittenBytes, buf.writtenBytes(), buf.totalBytes());
                }
                catch (AsynchronousCloseException e) {
                    continue;
                }
                catch (Throwable t) {
                    if (buf != null) {
                        buf.release();
                    }
                    channel.currentWriteEvent = null;
                    channel.currentWriteBuffer = null;
                    buf = null;
                    evt = null;
                    if (future != null) {
                        future.setFailure(t);
                    }
                    if (iothread) {
                        Channels.fireExceptionCaught(channel, t);
                    } else {
                        Channels.fireExceptionCaughtLater(channel, t);
                    }
                    if (!(t instanceof IOException)) continue;
                    open = false;
                    this.close(channel, Channels.succeededFuture(channel));
                    continue;
                }
                break;
            }
            channel.inWriteNowLoop = false;
            if (open) {
                if (addOpWrite) {
                    this.setOpWrite(channel);
                } else if (removeOpWrite) {
                    this.clearOpWrite(channel);
                }
            }
        }
        if (iothread) {
            Channels.fireWriteComplete(channel, writtenBytes);
        } else {
            Channels.fireWriteCompleteLater(channel, writtenBytes);
        }
    }

    static boolean isIoThread(AbstractNioChannel<?> channel) {
        return Thread.currentThread() == channel.worker.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setOpWrite(AbstractNioChannel<?> channel) {
        Selector selector = this.selector;
        SelectionKey key = ((SelectableChannel)channel.channel).keyFor(selector);
        if (key == null) {
            return;
        }
        if (!key.isValid()) {
            this.close(key);
            return;
        }
        Object object = channel.interestOpsLock;
        synchronized (object) {
            int interestOps = channel.getRawInterestOps();
            if ((interestOps & 4) == 0) {
                key.interestOps(interestOps |= 4);
                channel.setRawInterestOpsNow(interestOps);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearOpWrite(AbstractNioChannel<?> channel) {
        Selector selector = this.selector;
        SelectionKey key = ((SelectableChannel)channel.channel).keyFor(selector);
        if (key == null) {
            return;
        }
        if (!key.isValid()) {
            this.close(key);
            return;
        }
        Object object = channel.interestOpsLock;
        synchronized (object) {
            int interestOps = channel.getRawInterestOps();
            if ((interestOps & 4) != 0) {
                key.interestOps(interestOps &= 0xFFFFFFFB);
                channel.setRawInterestOpsNow(interestOps);
            }
        }
    }

    void close(AbstractNioChannel<?> channel, ChannelFuture future) {
        boolean connected = channel.isConnected();
        boolean bound = channel.isBound();
        boolean iothread = AbstractNioWorker.isIoThread(channel);
        try {
            ((AbstractInterruptibleChannel)channel.channel).close();
            ++this.cancelledKeys;
            if (channel.setClosed()) {
                future.setSuccess();
                if (connected) {
                    if (iothread) {
                        Channels.fireChannelDisconnected(channel);
                    } else {
                        Channels.fireChannelDisconnectedLater(channel);
                    }
                }
                if (bound) {
                    if (iothread) {
                        Channels.fireChannelUnbound(channel);
                    } else {
                        Channels.fireChannelUnboundLater(channel);
                    }
                }
                AbstractNioWorker.cleanUpWriteBuffer(channel);
                if (iothread) {
                    Channels.fireChannelClosed(channel);
                } else {
                    Channels.fireChannelClosedLater(channel);
                }
            } else {
                future.setSuccess();
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            if (iothread) {
                Channels.fireExceptionCaught(channel, t);
            }
            Channels.fireExceptionCaughtLater(channel, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void cleanUpWriteBuffer(AbstractNioChannel<?> channel) {
        Exception cause = null;
        boolean fireExceptionCaught = false;
        Object object = channel.writeLock;
        synchronized (object) {
            MessageEvent evt = channel.currentWriteEvent;
            if (evt != null) {
                cause = channel.isOpen() ? new NotYetConnectedException() : new ClosedChannelException();
                ChannelFuture future = evt.getFuture();
                if (channel.currentWriteBuffer != null) {
                    channel.currentWriteBuffer.release();
                    channel.currentWriteBuffer = null;
                }
                channel.currentWriteEvent = null;
                evt = null;
                future.setFailure(cause);
                fireExceptionCaught = true;
            }
            Queue<MessageEvent> writeBuffer = channel.writeBufferQueue;
            while ((evt = writeBuffer.poll()) != null) {
                if (cause == null) {
                    cause = channel.isOpen() ? new NotYetConnectedException() : new ClosedChannelException();
                    fireExceptionCaught = true;
                }
                evt.getFuture().setFailure(cause);
            }
        }
        if (fireExceptionCaught) {
            if (AbstractNioWorker.isIoThread(channel)) {
                Channels.fireExceptionCaught(channel, (Throwable)cause);
            } else {
                Channels.fireExceptionCaughtLater(channel, (Throwable)cause);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInterestOps(AbstractNioChannel<?> channel, ChannelFuture future, int interestOps) {
        boolean changed = false;
        boolean iothread = AbstractNioWorker.isIoThread(channel);
        try {
            Object object = channel.interestOpsLock;
            synchronized (object) {
                Selector selector = this.selector;
                SelectionKey key = ((SelectableChannel)channel.channel).keyFor(selector);
                interestOps &= 0xFFFFFFFB;
                interestOps |= channel.getRawInterestOps() & 4;
                if (key == null || selector == null) {
                    if (channel.getRawInterestOps() != interestOps) {
                        changed = true;
                    }
                    channel.setRawInterestOpsNow(interestOps);
                    future.setSuccess();
                    if (changed) {
                        if (iothread) {
                            Channels.fireChannelInterestChanged(channel);
                        } else {
                            Channels.fireChannelInterestChangedLater(channel);
                        }
                    }
                    return;
                }
                switch (CONSTRAINT_LEVEL) {
                    case 0: {
                        if (channel.getRawInterestOps() == interestOps) break;
                        key.interestOps(interestOps);
                        if (Thread.currentThread() != this.thread && this.wakenUp.compareAndSet(false, true)) {
                            selector.wakeup();
                        }
                        changed = true;
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (channel.getRawInterestOps() == interestOps) break;
                        if (Thread.currentThread() == this.thread) {
                            key.interestOps(interestOps);
                            changed = true;
                            break;
                        }
                        this.selectorGuard.readLock().lock();
                        try {
                            if (this.wakenUp.compareAndSet(false, true)) {
                                selector.wakeup();
                            }
                            key.interestOps(interestOps);
                            changed = true;
                            Object var10_12 = null;
                            this.selectorGuard.readLock().unlock();
                            break;
                        }
                        catch (Throwable throwable) {
                            Object var10_13 = null;
                            this.selectorGuard.readLock().unlock();
                            throw throwable;
                        }
                    }
                    default: {
                        throw new Error();
                    }
                }
                if (changed) {
                    channel.setRawInterestOpsNow(interestOps);
                }
            }
            future.setSuccess();
            if (changed) {
                if (iothread) {
                    Channels.fireChannelInterestChanged(channel);
                } else {
                    Channels.fireChannelInterestChangedLater(channel);
                }
            }
        }
        catch (CancelledKeyException e) {
            ClosedChannelException cce = new ClosedChannelException();
            future.setFailure(cce);
            if (iothread) {
                Channels.fireExceptionCaught(channel, (Throwable)cce);
            } else {
                Channels.fireExceptionCaughtLater(channel, (Throwable)cce);
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            if (iothread) {
                Channels.fireExceptionCaught(channel, t);
            }
            Channels.fireExceptionCaughtLater(channel, t);
        }
    }

    @Override
    public void releaseExternalResources() {
        this.sendBufferPool.releaseExternalResources();
    }

    protected abstract boolean read(SelectionKey var1);

    protected abstract Runnable createRegisterTask(AbstractNioChannel<?> var1, ChannelFuture var2);
}

