/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.fest.assertions.ObjectGroupAssert;
import org.fest.assertions.PropertySupport;
import org.fest.util.ToString;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratorAssert
extends ObjectGroupAssert<IteratorAssert, Iterator<?>> {
    protected IteratorAssert(Iterator<?> actual) {
        super(IteratorAssert.class, IteratorAssert.wrap(actual));
    }

    private static Iterator<?> wrap(Iterator<?> actual) {
        if (actual == null) {
            return null;
        }
        return new PrettyPrintIterator(actual);
    }

    @Override
    protected IteratorAssert onProperty(String propertyName) {
        this.isNotNull();
        List<Object> subset = PropertySupport.instance().propertyValues(propertyName, this.contentOfActual());
        return new IteratorAssert(subset.iterator());
    }

    @Override
    protected Set<Object> actualAsSet() {
        return new LinkedHashSet<Object>(this.contentOfActual());
    }

    @Override
    protected List<Object> actualAsList() {
        return new ArrayList<Object>(this.contentOfActual());
    }

    @Override
    protected int actualGroupSize() {
        this.isNotNull();
        return this.contentOfActual().size();
    }

    private List<Object> contentOfActual() {
        PrettyPrintIterator wrapped = (PrettyPrintIterator)this.actual;
        return wrapped.contents();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @VisibleForTesting
    static class PrettyPrintIterator
    implements Iterator<Object> {
        private final Iterator<?> wrapped;
        boolean wrappedWasConsumed;
        List<Object> wrappedContents;
        Iterator<Object> iterator;

        PrettyPrintIterator(Iterator<?> wrapped) {
            this.wrapped = wrapped;
        }

        List<Object> contents() {
            this.consumeIterator();
            return this.wrappedContents;
        }

        @Override
        public boolean hasNext() {
            this.consumeIterator();
            return this.iterator.hasNext();
        }

        @Override
        public Object next() {
            this.consumeIterator();
            return this.iterator.next();
        }

        private synchronized void consumeIterator() {
            if (this.wrappedWasConsumed) {
                return;
            }
            this.wrappedContents = new ArrayList<Object>();
            while (this.wrapped.hasNext()) {
                this.wrappedContents.add(this.wrapped.next());
            }
            this.wrappedWasConsumed = true;
            this.iterator = this.wrappedContents.iterator();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            this.consumeIterator();
            return ToString.toStringOf(this.wrappedContents);
        }
    }
}

