/*
 * Decompiled with CFR 0.152.
 */
package jj.play.org.eclipse.mylyn.wikitext.textile.core;

import java.util.List;
import jj.play.org.eclipse.mylyn.internal.wikitext.textile.core.TextileContentState;
import jj.play.org.eclipse.mylyn.internal.wikitext.textile.core.block.CodeBlock;
import jj.play.org.eclipse.mylyn.internal.wikitext.textile.core.block.FootnoteBlock;
import jj.play.org.eclipse.mylyn.internal.wikitext.textile.core.block.HeadingBlock;
import jj.play.org.eclipse.mylyn.internal.wikitext.textile.core.block.ListBlock;
import jj.play.org.eclipse.mylyn.internal.wikitext.textile.core.block.ParagraphBlock;
import jj.play.org.eclipse.mylyn.internal.wikitext.textile.core.block.PreformattedBlock;
import jj.play.org.eclipse.mylyn.internal.wikitext.textile.core.block.QuoteBlock;
import jj.play.org.eclipse.mylyn.internal.wikitext.textile.core.block.TableBlock;
import jj.play.org.eclipse.mylyn.internal.wikitext.textile.core.block.TableOfContentsBlock;
import jj.play.org.eclipse.mylyn.internal.wikitext.textile.core.block.TextileGlossaryBlock;
import jj.play.org.eclipse.mylyn.internal.wikitext.textile.core.phrase.EscapeTextilePhraseModifier;
import jj.play.org.eclipse.mylyn.internal.wikitext.textile.core.phrase.ImageTextilePhraseModifier;
import jj.play.org.eclipse.mylyn.internal.wikitext.textile.core.phrase.SimpleTextilePhraseModifier;
import jj.play.org.eclipse.mylyn.internal.wikitext.textile.core.token.FootnoteReferenceReplacementToken;
import jj.play.org.eclipse.mylyn.internal.wikitext.textile.core.token.HyperlinkReplacementToken;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.builder.NoOpDocumentBuilder;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.markup.AbstractMarkupLanguage;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.markup.Block;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.markup.ContentState;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguageConfiguration;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.markup.phrase.HtmlEndTagPhraseModifier;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.markup.phrase.HtmlStartTagPhraseModifier;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.markup.token.AcronymReplacementToken;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.markup.token.EntityReferenceReplacementToken;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.markup.token.EntityWrappingReplacementToken;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.markup.token.PatternEntityReferenceReplacementToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextileLanguage
extends AbstractMarkupLanguage {
    private boolean preprocessFootnotes = false;
    private TextileContentState currentState;

    public TextileLanguage() {
        this.setName("Textile");
    }

    protected void addBlockExtensions(List<Block> blocks, List<Block> paragraphBreakingBlocks) {
        blocks.add((Block)new TextileGlossaryBlock());
        blocks.add(new TableOfContentsBlock());
        super.addBlockExtensions(blocks, paragraphBreakingBlocks);
    }

    protected ContentState createState() {
        if (this.currentState != null) {
            TextileContentState temp = this.currentState;
            this.currentState = null;
            return temp;
        }
        return new TextileContentState();
    }

    protected void addStandardBlocks(List<Block> blocks, List<Block> paragraphBreakingBlocks) {
        blocks.add(new HeadingBlock());
        ListBlock listBlock = new ListBlock();
        blocks.add(listBlock);
        paragraphBreakingBlocks.add(listBlock);
        blocks.add(new PreformattedBlock());
        blocks.add(new QuoteBlock());
        blocks.add(new CodeBlock());
        blocks.add(new FootnoteBlock());
        TableBlock tableBlock = new TableBlock();
        blocks.add(tableBlock);
        paragraphBreakingBlocks.add(tableBlock);
    }

    protected void addStandardPhraseModifiers(MarkupLanguage.PatternBasedSyntax phraseModifierSyntax) {
        boolean escapingHtml = this.configuration == null ? false : this.configuration.isEscapingHtmlAndXml();
        phraseModifierSyntax.add((PatternBasedElement)new HtmlEndTagPhraseModifier(escapingHtml));
        phraseModifierSyntax.add((PatternBasedElement)new HtmlStartTagPhraseModifier(escapingHtml));
        phraseModifierSyntax.beginGroup("(?:(?<=[\\s\\.,\\\"'?!;:\\)\\(\\{\\}\\[\\]])|^)(?:", 0);
        phraseModifierSyntax.add((PatternBasedElement)new EscapeTextilePhraseModifier());
        phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("**", DocumentBuilder.SpanType.BOLD, SimpleTextilePhraseModifier.Mode.NESTING));
        phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("??", DocumentBuilder.SpanType.CITATION, SimpleTextilePhraseModifier.Mode.NESTING));
        phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("__", DocumentBuilder.SpanType.ITALIC, SimpleTextilePhraseModifier.Mode.NESTING));
        phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("_", DocumentBuilder.SpanType.EMPHASIS, SimpleTextilePhraseModifier.Mode.NESTING));
        phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("*", DocumentBuilder.SpanType.STRONG, SimpleTextilePhraseModifier.Mode.NESTING));
        phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("+", DocumentBuilder.SpanType.INSERTED, SimpleTextilePhraseModifier.Mode.NESTING));
        phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("~", DocumentBuilder.SpanType.SUBSCRIPT, SimpleTextilePhraseModifier.Mode.NORMAL));
        phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("^", DocumentBuilder.SpanType.SUPERSCRIPT, SimpleTextilePhraseModifier.Mode.NORMAL));
        phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("@", DocumentBuilder.SpanType.CODE, SimpleTextilePhraseModifier.Mode.SPECIAL));
        phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("%", DocumentBuilder.SpanType.SPAN, SimpleTextilePhraseModifier.Mode.NESTING));
        phraseModifierSyntax.add((PatternBasedElement)new SimpleTextilePhraseModifier("-", DocumentBuilder.SpanType.DELETED, SimpleTextilePhraseModifier.Mode.NESTING));
        phraseModifierSyntax.add((PatternBasedElement)new ImageTextilePhraseModifier());
        phraseModifierSyntax.endGroup(")(?=\\W|$)", 0);
    }

    protected void addStandardTokens(MarkupLanguage.PatternBasedSyntax tokenSyntax) {
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(tm)", "#8482"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(TM)", "#8482"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(c)", "#169"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(C)", "#169"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(r)", "#174"));
        tokenSyntax.add((PatternBasedElement)new EntityReferenceReplacementToken("(R)", "#174"));
        tokenSyntax.add((PatternBasedElement)new HyperlinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new FootnoteReferenceReplacementToken());
        if (this.configuration == null || !this.configuration.isOptimizeForRepositoryUsage()) {
            tokenSyntax.add((PatternBasedElement)new EntityWrappingReplacementToken("\"", "#8220", "#8221"));
            tokenSyntax.add((PatternBasedElement)new EntityWrappingReplacementToken("'", "#8216", "#8217"));
            tokenSyntax.add((PatternBasedElement)new PatternEntityReferenceReplacementToken("(?:(?<=\\w)(')(?=\\w))", "#8217"));
        }
        tokenSyntax.add((PatternBasedElement)new PatternEntityReferenceReplacementToken("(?:(?<=\\w\\s)(--)(?=\\s\\w))", "#8212"));
        tokenSyntax.add((PatternBasedElement)new PatternEntityReferenceReplacementToken("(?:(?<=\\w\\s)(-)(?=\\s\\w))", "#8211"));
        tokenSyntax.add((PatternBasedElement)new PatternEntityReferenceReplacementToken("(?:(?<=\\d\\s)(x)(?=\\s\\d))", "#215"));
        if (this.configuration == null || !this.configuration.isOptimizeForRepositoryUsage()) {
            tokenSyntax.add((PatternBasedElement)new AcronymReplacementToken());
        }
    }

    protected Block createParagraphBlock() {
        ParagraphBlock paragraphBlock = new ParagraphBlock();
        if (this.configuration != null && !this.configuration.isEnableUnwrappedParagraphs()) {
            paragraphBlock.setEnableUnwrapped(false);
        }
        return paragraphBlock;
    }

    public boolean isPreprocessFootnotes() {
        return this.preprocessFootnotes;
    }

    public void setPreprocessFootnotes(boolean preprocessFootnotes) {
        this.preprocessFootnotes = preprocessFootnotes;
    }

    public void configure(MarkupLanguageConfiguration configuration) throws UnsupportedOperationException {
        if (configuration.isOptimizeForRepositoryUsage()) {
            this.setPreprocessFootnotes(true);
        }
        super.configure(configuration);
    }

    public TextileLanguage clone() {
        TextileLanguage copy = (TextileLanguage)super.clone();
        copy.preprocessFootnotes = this.preprocessFootnotes;
        return copy;
    }

    public void processContent(MarkupParser parser, String markupContent, boolean asDocument) {
        if (this.preprocessFootnotes) {
            boolean previousBlocksOnly = this.isBlocksOnly();
            boolean previousFilterGenerativeContents = this.isFilterGenerativeContents();
            this.setBlocksOnly(true);
            this.setFilterGenerativeContents(true);
            DocumentBuilder builder = parser.getBuilder();
            parser.setBuilder((DocumentBuilder)new NoOpDocumentBuilder());
            TextileContentState preprocessingState = this.currentState = new TextileContentState();
            super.processContent(parser, markupContent, asDocument);
            this.setBlocksOnly(previousBlocksOnly);
            this.setFilterGenerativeContents(previousFilterGenerativeContents);
            this.currentState = new TextileContentState();
            this.currentState.setFootnoteNumbers(preprocessingState.getFootnoteNumbers());
            parser.setBuilder(builder);
            super.processContent(parser, markupContent, asDocument);
            this.currentState = null;
        } else {
            this.currentState = null;
            super.processContent(parser, markupContent, asDocument);
        }
    }

    public boolean isEmptyLine(String line) {
        return line.length() == 0;
    }
}

