/*
 * Decompiled with CFR 0.152.
 */
package jj.play.org.eclipse.mylyn.internal.wikitext.textile.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jj.play.org.eclipse.mylyn.wikitext.core.parser.markup.ContentState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextileContentState
extends ContentState {
    private static final Pattern NAMED_LINK_PATTERN = Pattern.compile("\\[(\\S+)\\]([a-zA-Z]{3,5}:\\S+)", 8);
    private final Map<String, String> nameToUrl = new HashMap<String, String>();
    private Set<String> footnoteNumbers;

    protected void setMarkupContent(String markupContent) {
        super.setMarkupContent(markupContent);
        this.preprocessContent(markupContent);
    }

    private void preprocessContent(String markupContent) {
        Matcher matcher = NAMED_LINK_PATTERN.matcher(markupContent);
        while (matcher.find()) {
            String name = matcher.group(1);
            String href = matcher.group(2);
            this.nameToUrl.put(name, href);
        }
    }

    public String getNamedLinkUrl(String name) {
        return this.nameToUrl.get(name);
    }

    public Set<String> getFootnoteNumbers() {
        return this.footnoteNumbers;
    }

    public void setFootnoteNumbers(Set<String> footnoteNumbers) {
        this.footnoteNumbers = footnoteNumbers;
    }

    public void footnoteBlockDetected(String footnoteNumber) {
        if (this.footnoteNumbers == null) {
            this.footnoteNumbers = new HashSet<String>();
        }
        this.footnoteNumbers.add(footnoteNumber);
    }

    public boolean hasFootnoteNumber(String footnoteNumber) {
        return this.footnoteNumbers != null && this.footnoteNumbers.contains(footnoteNumber);
    }
}

