/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.com.jhlabs.image;

import java.awt.image.RGBImageFilter;
import java.io.Serializable;
import jj.play.ns.com.jhlabs.image.ImageMath;

public class WeaveFilter
extends RGBImageFilter
implements Serializable {
    static final long serialVersionUID = 4847932412277504482L;
    private double xWidth = 16.0;
    private double yWidth = 16.0;
    private double xGap = 6.0;
    private double yGap = 6.0;
    private int rows = 4;
    private int cols = 4;
    private int rgbX = -32640;
    private int rgbY = -8355585;
    private boolean useImageColors = true;
    private boolean roundThreads = false;
    private boolean shadeCrossings = true;
    public int[][] matrix;

    public WeaveFilter() {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[3] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 1;
        nArray2[2] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[1] = 1;
        nArray3[3] = 1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[0] = 1;
        nArray4[2] = 1;
        nArrayArray[3] = nArray4;
        this.matrix = nArrayArray;
    }

    public void setXGap(double d) {
        this.xGap = d;
    }

    public void setXWidth(double d) {
        this.xWidth = d;
    }

    public double getXWidth() {
        return this.xWidth;
    }

    public void setYWidth(double d) {
        this.yWidth = d;
    }

    public double getYWidth() {
        return this.yWidth;
    }

    public double getXGap() {
        return this.xGap;
    }

    public void setYGap(double d) {
        this.yGap = d;
    }

    public double getYGap() {
        return this.yGap;
    }

    public void setCrossings(int[][] nArray) {
        this.matrix = nArray;
    }

    public int[][] getCrossings() {
        return this.matrix;
    }

    public void setUseImageColors(boolean bl) {
        this.useImageColors = bl;
    }

    public boolean getUseImageColors() {
        return this.useImageColors;
    }

    public void setRoundThreads(boolean bl) {
        this.roundThreads = bl;
    }

    public boolean getRoundThreads() {
        return this.roundThreads;
    }

    public void setShadeCrossings(boolean bl) {
        this.shadeCrossings = bl;
    }

    public boolean getShadeCrossings() {
        return this.shadeCrossings;
    }

    public int filterRGB(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        double d;
        double d2;
        double d3;
        double d4;
        boolean bl;
        n = (int)((double)n + (this.xWidth + this.xGap / 2.0));
        n2 = (int)((double)n2 + (this.yWidth + this.yGap / 2.0));
        double d5 = ImageMath.mod((double)n, this.xWidth + this.xGap);
        double d6 = ImageMath.mod((double)n2, this.yWidth + this.yGap);
        int n7 = (int)((double)n / (this.xWidth + this.xGap));
        int n8 = (int)((double)n2 / (this.yWidth + this.yGap));
        boolean bl2 = d5 < this.xWidth;
        boolean bl3 = bl = d6 < this.yWidth;
        if (this.roundThreads) {
            d4 = Math.abs(this.xWidth / 2.0 - d5) / this.xWidth / 2.0;
            d3 = Math.abs(this.yWidth / 2.0 - d6) / this.yWidth / 2.0;
        } else {
            d3 = 0.0;
            d4 = 0.0;
        }
        if (this.shadeCrossings) {
            d2 = ImageMath.smoothStep(this.xWidth / 2.0, this.xWidth / 2.0 + this.xGap, Math.abs(this.xWidth / 2.0 - d5));
            d = ImageMath.smoothStep(this.yWidth / 2.0, this.yWidth / 2.0 + this.yGap, Math.abs(this.yWidth / 2.0 - d6));
        } else {
            d = 0.0;
            d2 = 0.0;
        }
        if (this.useImageColors) {
            n5 = n6 = n3;
        } else {
            n5 = this.rgbX;
            n6 = this.rgbY;
        }
        int n9 = n7 % this.cols;
        int n10 = n8 % this.rows;
        int n11 = this.matrix[n10][n9];
        if (bl2) {
            if (bl) {
                n4 = n11 == 1 ? n5 : n6;
                n4 = ImageMath.mixColors(2.0 * (n11 == 1 ? d4 : d3), n4, -16777216);
            } else {
                if (this.shadeCrossings) {
                    if (n11 != this.matrix[(n8 + 1) % this.rows][n9]) {
                        if (n11 == 0) {
                            d = 1.0 - d;
                        }
                        n5 = ImageMath.mixColors(d *= 0.5, n5, -16777216);
                    } else if (n11 == 0) {
                        n5 = ImageMath.mixColors(0.5, n5, -16777216);
                    }
                }
                n4 = ImageMath.mixColors(2.0 * d4, n5, -16777216);
            }
        } else if (bl) {
            if (this.shadeCrossings) {
                if (n11 != this.matrix[n10][(n7 + 1) % this.cols]) {
                    if (n11 == 1) {
                        d2 = 1.0 - d2;
                    }
                    n6 = ImageMath.mixColors(d2 *= 0.5, n6, -16777216);
                } else if (n11 == 1) {
                    n6 = ImageMath.mixColors(0.5, n6, -16777216);
                }
            }
            n4 = ImageMath.mixColors(2.0 * d3, n6, -16777216);
        } else {
            n4 = 0;
        }
        return n4;
    }

    public String toString() {
        return "Texture/Weave...";
    }
}

