/*
 * Decompiled with CFR 0.152.
 */
package jj.play.ns.com.jhlabs.image;

import jj.play.ns.com.jhlabs.image.Kernel;
import jj.play.ns.com.jhlabs.image.PixelUtils;
import jj.play.ns.com.jhlabs.image.WholeImageFilter;

public class ConvolveFilter
extends WholeImageFilter {
    static final long serialVersionUID = 2239251672685254626L;
    protected Kernel kernel = null;
    public boolean alpha = true;

    public ConvolveFilter() {
        this(new double[9]);
    }

    public ConvolveFilter(double[] dArray) {
        this(new Kernel(3, 3, dArray));
    }

    public ConvolveFilter(int n, int n2, double[] dArray) {
        this(new Kernel(n, n2, dArray));
    }

    public ConvolveFilter(Kernel kernel) {
        this.kernel = kernel;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public Kernel getKernel() {
        return this.kernel;
    }

    public void imageComplete(int n) {
        if (n == 1 || n == 4) {
            this.consumer.imageComplete(n);
            return;
        }
        int n2 = this.originalSpace.width;
        int n3 = this.originalSpace.height;
        int[] nArray = new int[n2 * n3];
        ConvolveFilter.convolve(this.kernel, this.inPixels, nArray, n2, n3, this.alpha);
        this.consumer.setPixels(0, 0, n2, n3, this.defaultRGBModel, nArray, 0, n2);
        this.consumer.imageComplete(n);
        this.inPixels = null;
    }

    public static void convolve(Kernel kernel, int[] nArray, int[] nArray2, int n, int n2) {
        ConvolveFilter.convolve(kernel, nArray, nArray2, n, n2, true);
    }

    public static void convolve(Kernel kernel, int[] nArray, int[] nArray2, int n, int n2, boolean bl) {
        int n3 = 0;
        double[] dArray = kernel.matrix;
        int n4 = kernel.rows;
        int n5 = kernel.cols;
        int n6 = n4 / 2;
        int n7 = n5 / 2;
        int n8 = 0;
        while (n8 < n2) {
            int n9 = 0;
            while (n9 < n) {
                int n10;
                int n11;
                int n12;
                int n13;
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                int n14 = -n6;
                while (n14 <= n6) {
                    n13 = n8 + n14;
                    n12 = n13 >= 0 && n13 < n2 ? n13 * n : n8 * n;
                    n11 = n5 * (n14 + n6) + n7;
                    n10 = -n7;
                    while (n10 <= n7) {
                        double d5 = dArray[n11 + n10];
                        if (d5 != 0.0) {
                            int n15 = n9 + n10;
                            if (n15 < 0 || n15 >= n) {
                                n15 = n9;
                            }
                            int n16 = nArray[n12 + n15];
                            d4 += d5 * (double)(n16 >> 24 & 0xFF);
                            d += d5 * (double)(n16 >> 16 & 0xFF);
                            d2 += d5 * (double)(n16 >> 8 & 0xFF);
                            d3 += d5 * (double)(n16 & 0xFF);
                        }
                        ++n10;
                    }
                    ++n14;
                }
                n13 = bl ? PixelUtils.clamp((int)(d4 + 0.5)) : 255;
                n12 = PixelUtils.clamp((int)(d + 0.5));
                n11 = PixelUtils.clamp((int)(d2 + 0.5));
                n10 = PixelUtils.clamp((int)(d3 + 0.5));
                nArray2[n3++] = n13 << 24 | n12 << 16 | n11 << 8 | n10;
                ++n9;
            }
            ++n8;
        }
    }

    public String toString() {
        return "Blur/Convolve...";
    }
}

