/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.ps.ImageEncoderJPEG;
import org.apache.fop.render.ps.PSImageFormResource;
import org.apache.fop.render.ps.PSImageHandler;
import org.apache.fop.render.ps.PSRenderingContext;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.impl.ImageRawJPEG;
import org.apache.xmlgraphics.ps.ImageEncoder;
import org.apache.xmlgraphics.ps.ImageFormGenerator;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSImageUtils;

public class PSImageHandlerRawJPEG
implements PSImageHandler {
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{ImageFlavor.RAW_JPEG};

    @Override
    public void handleImage(RenderingContext context, Image image, Rectangle pos) throws IOException {
        PSRenderingContext psContext = (PSRenderingContext)context;
        PSGenerator gen = psContext.getGenerator();
        ImageRawJPEG jpeg = (ImageRawJPEG)image;
        float x = (float)pos.getX() / 1000.0f;
        float y = (float)pos.getY() / 1000.0f;
        float w = (float)pos.getWidth() / 1000.0f;
        float h = (float)pos.getHeight() / 1000.0f;
        Rectangle2D.Float targetRect = new Rectangle2D.Float(x, y, w, h);
        ImageInfo info = image.getInfo();
        ImageEncoderJPEG encoder = new ImageEncoderJPEG(jpeg);
        PSImageUtils.writeImage((ImageEncoder)encoder, info.getSize().getDimensionPx(), info.getOriginalURI(), (Rectangle2D)targetRect, jpeg.getColorSpace(), 8, jpeg.isInverted(), gen);
    }

    @Override
    public void generateForm(RenderingContext context, Image image, PSImageFormResource form) throws IOException {
        PSRenderingContext psContext = (PSRenderingContext)context;
        PSGenerator gen = psContext.getGenerator();
        ImageRawJPEG jpeg = (ImageRawJPEG)image;
        ImageInfo info = image.getInfo();
        String imageDescription = info.getMimeType() + " " + info.getOriginalURI();
        ImageEncoderJPEG encoder = new ImageEncoderJPEG(jpeg);
        ImageFormGenerator formGen = new ImageFormGenerator(form.getName(), imageDescription, info.getSize().getDimensionPt(), info.getSize().getDimensionPx(), encoder, jpeg.getColorSpace(), jpeg.isInverted());
        formGen.generate(gen);
    }

    @Override
    public int getPriority() {
        return 200;
    }

    @Override
    public Class getSupportedImageClass() {
        return ImageRawJPEG.class;
    }

    @Override
    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }

    @Override
    public boolean isCompatible(RenderingContext targetContext, Image image) {
        PSRenderingContext psContext;
        if (targetContext instanceof PSRenderingContext && (psContext = (PSRenderingContext)targetContext).getGenerator().getPSLevel() >= 2) {
            return image == null || image instanceof ImageRawJPEG;
        }
        return false;
    }
}

