/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.shape;

import java.util.StringTokenizer;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UText;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.utils.Log;

public class TileText
extends AbstractTextBlock
implements TextBlock {
    private final String text;
    private final FontConfiguration fontConfiguration;
    private final Url url;

    public TileText(String text, FontConfiguration fontConfiguration, Url url) {
        this.fontConfiguration = fontConfiguration;
        this.text = text;
        this.url = url;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D rect = stringBounder.calculateDimension(this.fontConfiguration.getFont(), this.text);
        int spaceBottom = Math.abs(this.fontConfiguration.getSpace());
        Log.debug("g2d=" + rect);
        Log.debug("Size for " + this.text + " is " + rect);
        double h = rect.getHeight();
        if (h < 10.0) {
            h = 10.0;
        }
        double width = this.text.indexOf(9) == -1 ? rect.getWidth() : this.getWidth(stringBounder);
        return new XDimension2D(width, h + (double)spaceBottom);
    }

    public double getFontSize2D() {
        return this.fontConfiguration.getFont().getSize2D();
    }

    double getTabSize(StringBounder stringBounder) {
        return stringBounder.calculateDimension(this.fontConfiguration.getFont(), "        ").getWidth();
    }

    @Override
    public void drawU(UGraphic ug) {
        double x = 0.0;
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        ug = ug.apply(this.fontConfiguration.getColor());
        StringTokenizer tokenizer = new StringTokenizer(this.text, "\t", true);
        if (tokenizer.hasMoreTokens()) {
            double tabSize = this.getTabSize(ug.getStringBounder());
            while (tokenizer.hasMoreTokens()) {
                String s = tokenizer.nextToken();
                if (s.equals("\t")) {
                    double remainder = x % tabSize;
                    x += tabSize - remainder;
                    continue;
                }
                UText utext = new UText(s, this.fontConfiguration);
                XDimension2D dim = ug.getStringBounder().calculateDimension(this.fontConfiguration.getFont(), s);
                int space = this.fontConfiguration.getSpace();
                double ypos = space < 0 ? (double)space : (double)space;
                ug.apply(new UTranslate(x, ypos)).draw(utext);
                x += dim.getWidth();
            }
        }
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    double getWidth(StringBounder stringBounder) {
        StringTokenizer tokenizer = new StringTokenizer(this.text, "\t", true);
        double tabSize = this.getTabSize(stringBounder);
        double x = 0.0;
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            if (s.equals("\t")) {
                double remainder = x % tabSize;
                x += tabSize - remainder;
                continue;
            }
            XDimension2D dim = stringBounder.calculateDimension(this.fontConfiguration.getFont(), s);
            x += dim.getWidth();
        }
        return x;
    }
}

