/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.drawing.visio;

import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.klimt.ClipContainer;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.legacy.AtomText;
import net.sourceforge.plantuml.klimt.drawing.AbstractCommonUGraphic;
import net.sourceforge.plantuml.klimt.drawing.AbstractUGraphic;
import net.sourceforge.plantuml.klimt.drawing.visio.DriverDotPathVdx;
import net.sourceforge.plantuml.klimt.drawing.visio.DriverLineVdx;
import net.sourceforge.plantuml.klimt.drawing.visio.DriverPathVdx;
import net.sourceforge.plantuml.klimt.drawing.visio.DriverPolygonVdx;
import net.sourceforge.plantuml.klimt.drawing.visio.DriverRectangleVdx;
import net.sourceforge.plantuml.klimt.drawing.visio.DriverTextVdx;
import net.sourceforge.plantuml.klimt.drawing.visio.VisioGraphics;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.shape.DotPath;
import net.sourceforge.plantuml.klimt.shape.UCenteredCharacter;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.UImage;
import net.sourceforge.plantuml.klimt.shape.UImageSvg;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.klimt.shape.UText;

public class UGraphicVdx
extends AbstractUGraphic<VisioGraphics>
implements ClipContainer {
    @Override
    public double dpiFactor() {
        return 1.0;
    }

    public UGraphicVdx(HColor defaultBackground, ColorMapper colorMapper, StringBounder stringBounder) {
        super(defaultBackground, colorMapper, stringBounder, new VisioGraphics());
        this.register();
    }

    @Override
    protected AbstractCommonUGraphic copyUGraphic() {
        return new UGraphicVdx(this);
    }

    private UGraphicVdx(UGraphicVdx other) {
        super(other);
        this.register();
    }

    private void register() {
        this.registerDriver(URectangle.class, new DriverRectangleVdx());
        this.registerDriver(UText.class, new DriverTextVdx(this.getStringBounder()));
        this.ignoreShape(AtomText.class);
        this.registerDriver(ULine.class, new DriverLineVdx());
        this.registerDriver(UPolygon.class, new DriverPolygonVdx());
        this.ignoreShape(UEllipse.class);
        this.ignoreShape(UImage.class);
        this.ignoreShape(UImageSvg.class);
        this.registerDriver(UPath.class, new DriverPathVdx());
        this.registerDriver(DotPath.class, new DriverDotPathVdx());
        this.ignoreShape(UCenteredCharacter.class);
    }

    @Override
    public void writeToStream(OutputStream os, String metadata, int dpi) throws IOException {
        ((VisioGraphics)this.getGraphicObject()).createVsd(os);
    }

    @Override
    public boolean matchesProperty(String propertyName) {
        return "SPECIALTXT".equalsIgnoreCase(propertyName);
    }
}

