/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.regex.Matcher2;
import net.sourceforge.plantuml.regex.MyPattern;
import net.sourceforge.plantuml.regex.Pattern2;

public class SvgAttributes {
    private final Map<String, String> attributes = new TreeMap<String, String>();

    public SvgAttributes() {
    }

    private SvgAttributes(SvgAttributes other) {
        this.attributes.putAll(other.attributes);
    }

    public SvgAttributes(String args) {
        Pattern2 p = MyPattern.cmpile("(\\w+)\\s*=\\s*([%g][^%g]*[%g]|(?:\\w+))");
        Matcher2 m = p.matcher(args);
        while (m.find()) {
            this.attributes.put(m.group(1), StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(m.group(2)));
        }
    }

    public Map<String, String> attributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public SvgAttributes add(String key, String value) {
        SvgAttributes result = new SvgAttributes(this);
        result.attributes.put(key, value);
        return result;
    }

    public SvgAttributes add(SvgAttributes toBeAdded) {
        SvgAttributes result = new SvgAttributes(this);
        result.attributes.putAll(toBeAdded.attributes);
        return result;
    }
}

